% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/InteractionClassification.R
\name{InteractionClassification}
\alias{InteractionClassification}
\title{Classify HIV phenotype interactions using k-means clustering}
\usage{
InteractionClassification(cd_result, vl_result, k = 4, ns = 100, seed = 123)
}
\arguments{
\item{cd_result}{A numeric vector of differences in CD4 T-cell counts.}

\item{vl_result}{A numeric vector of differences in log viral load.}

\item{k}{Integer. The number of clusters to use in k-means. Default is 4.}

\item{ns}{Integer. Number of random initializations for the k-means algorithm. Default is 100.}

\item{seed}{Integer. Seed for random number generation to ensure reproducibility. Default is 123.}
}
\value{
A \code{data.frame} of class \code{InteractionClassification} with three columns:
\describe{
\item{cds3_result}{The CD4 count difference for each interaction.}
\item{vlogs3_result}{The viral load difference (log scale) for each interaction.}
\item{classification}{An integer label (1 to \code{k}) indicating the interaction cluster.}
}
}
\description{
This function performs k-means clustering on the differences in viral load and CD4 counts
to classify interaction types between HIV phenotypes. It returns an object of class
\code{InteractionClassification}, a \code{data.frame} with classification labels.
}
\examples{
set.seed(42)
data(cd_3)
cd_data <- cd_3[,-1]
cd_result <- cds_diff(cd_data)
data(vl_3)
vl_data <- vl_3[,-1]
vl_result <- vlogs_diff(vl_data)
result <- InteractionClassification(cd_result = cd_result, vl_result = vl_result)
}
