% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bathyMap.R
\name{bathyMap}
\alias{bathyMap}
\title{Plot Bathymetry Map}
\usage{
bathyMap(
  DEM,
  contours = TRUE,
  start = NULL,
  end = NULL,
  by = 5,
  breaks = NULL,
  units = "ft",
  labels = TRUE,
  textSize = 1.5,
  plotTitle = NULL
)
}
\arguments{
\item{DEM}{SpatRaster object of a given waterbody, rasters can be transformed to SpatRaster via the rast() function in 'terra'}

\item{contours}{logical indicating whether contours should included (TRUE) or not (FALSE), default = TRUE}

\item{start}{numeric value describing what value contours should start at, default = 0}

\item{end}{numeric value describing what value contours should end at, default = max depth}

\item{by}{numeric value describing contour intervals, default = 5}

\item{breaks}{optional numeric vector describing specific contours to include if contours = T, default = NULL}

\item{units}{character describing units of depth measurement, default = "ft"}

\item{labels}{logical indicating whether labels should be included (TRUE) or not (FALSE), default = TRUE}

\item{textSize}{number describing text size of contour labels if included, default = 1.5}

\item{plotTitle}{optional character string adding title to output plot}
}
\value{
ggplot object
}
\description{
Generate a bathymetry map from a provided DEM raster with optional contours and depth labels.
}
\examples{
#load raster
DEM <- terra::rast(system.file("extdata", "example_raster.tif", package = 'rLakeHabitat'))
#run function
bathyMap(DEM, contours = TRUE, units = 'm', labels = TRUE)
}
\author{
Tristan Blechinger, Department of Zoology & Physiology, University of Wyoming
}
