% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/export_mesh.R
\name{export_mesh}
\alias{export_mesh}
\title{Export Mesh}
\usage{
export_mesh(
  cylinder,
  filename,
  radius = NULL,
  color = NULL,
  palette = NULL,
  facets = 6,
  normals = FALSE
)
}
\arguments{
\item{cylinder}{QSM cylinder data frame}

\item{filename}{File name and path for exporting. The .ply extension is automatically added if not present.}

\item{radius}{Radius column name either quoted or unquoted. Defaults to modified cylinders from the cylinder data frame.}

\item{color}{Optional cylinder color parameter. Colors must be a single hex color string, a \code{grDevices::colors()}, a vector of hex colors, or a quoted/unquoted column name. It can also be set to "random" to generate a random solid color, or FALSE to disable color on export. Vectors must have the same length as the cylinder data frame.}

\item{palette}{Optional color palette for numerical data. Palettes include \code{colourvalues::color_palettes()} or a user supplied RGB palette matrix with the length of cylinder.}

\item{facets}{The number of facets in the polygon cross section. Defaults to 6, but can be increased to improve visual smoothness at the cost of performance and memory.}

\item{normals}{Option to export normals. Defaults to FALSE, but can be set to TRUE.}
}
\value{
A mesh .ply file
}
\description{
Exports QSM cylinder mesh using the rgl library
}
\examples{

## TreeQSM Processing Chain
file <- system.file("extdata/QSM.mat", package = "rTwig")
qsm <- import_qsm(file)
cylinder <- qsm$cylinder
cylinder <- update_cylinders(cylinder)

filename <- tempfile(pattern = "TreeQSM_mesh")
export_mesh(cylinder, filename)

## SimpleForest Processing Chain
file <- system.file("extdata/QSM.csv", package = "rTwig")
cylinder <- read.csv(file)
cylinder <- update_cylinders(cylinder)

filename <- tempfile(pattern = "SimpleForest_mesh")
export_mesh(cylinder, filename)

}
