% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mieaa.R
\name{rba_mieaa_cats}
\alias{rba_mieaa_cats}
\title{Get Supported Enrichment Categories for a Species and miRNA Type}
\usage{
rba_mieaa_cats(mirna_type, species, ...)
}
\arguments{
\item{mirna_type}{Type of your miRNA accession. either "mature" or
"precursor".}

\item{species}{Fully or partially matching Scientific name, abbreviation
or NCBI taxon ID of one of the following species: \enumerate{
\item "Homo sapiens", "hsa" or 9606
\item "Mus musculus", "mmu" or 10090
\item "Rattus norvegicus", "rno" or 10116
\item "Arabidopsis thaliana", "ath" or 3702
\item "Bos taurus", "bta" or 9913
\item "Caenorhabditis elegans", "cel" or 6239
\item "Drosophila melanogaster", "dme" or 7227
\item "Danio rerio", "dre" or 7955
\item "Gallus gallus", "gga" or 9031
\item "Sus scrofa", "ssc" or  9823}}

\item{...}{rbioapi option(s). See \code{\link{rba_options}}'s
arguments manual for more information on available options.}
}
\value{
a named character vector with the supported categories for
  your supplied input combination.
}
\description{
For each Combination of species and miRNA type, Only a pre-defined
  categories groups are supported. Use this function to retrieve a list
  of supported categories for a given combination of Species and miRNA type.
}
\section{Corresponding API Resources}{

 "GET https://ccb-compute2.cs.uni-saarland.de/mieaa2/api/v1/enrichment_categories/\{species\}/\{mirna_type\}/"
}

\examples{
\donttest{
rba_mieaa_cats("mature", "Homo sapiens")
}

}
\references{
\itemize{
  \item Fabian Kern, Tobias Fehlmann, Jeffrey Solomon, Louisa Schwed,
  Nadja Grammes, Christina Backes, Kendall Van Keuren-Jensen,
  David Wesley Craig,Eckart Meese, Andreas Keller, miEAA 2.0:
  integrating multi-species microRNA enrichment analysis and workflow
  management systems, Nucleic Acids Research, Volume 48, Issue W1,
  02 July 2020, Pages W521–W528, https://doi.org/10.1093/nar/gkaa309
  \item
  \href{https://ccb-compute2.cs.uni-saarland.de/mieaa2/tutorial/api/}{miEAA
  browsable API tutorial}
  \item \href{https://ccb-compute2.cs.uni-saarland.de/mieaa2/}{Citations note
  on miEAA website}
  }
}
\seealso{
Other "miEAA": 
\code{\link{rba_mieaa_convert_type}()},
\code{\link{rba_mieaa_convert_version}()},
\code{\link{rba_mieaa_enrich}()},
\code{\link{rba_mieaa_enrich_results}()},
\code{\link{rba_mieaa_enrich_status}()},
\code{\link{rba_mieaa_enrich_submit}()}
}
\concept{"miEAA"}
