% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_methods.r, R/taxa_table.r
\name{subset}
\alias{subset}
\alias{subset.rbiom}
\alias{[.rbiom}
\alias{na.omit.rbiom}
\alias{subset_taxa}
\title{Subset an rbiom object by sample names, OTU names, metadata, or taxonomy.}
\usage{
\method{subset}{rbiom}(x, subset, clone = TRUE, ...)

\method{[}{rbiom}(x, i, j, ..., clone = TRUE, drop = FALSE)

\method{na.omit}{rbiom}(object, fields = ".all", clone = TRUE, ...)

subset_taxa(x, subset, clone = TRUE, ...)
}
\arguments{
\item{x}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.}

\item{subset}{Logical expression for rows to keep. See \code{\link[base:subset]{base::subset()}}.}

\item{clone}{Create a copy of \code{biom} before modifying. If \code{FALSE}, \code{biom}
is modified in place as a side-effect. See \link[=speed]{speed ups} for
use cases. Default: \code{TRUE}}

\item{...}{Not used.}

\item{i, j}{The sample or OTU names to keep. Or a logical/integer vector
indicating which sample names from \code{biom$samples} or \code{biom$otus} to
keep. Subsetting with \verb{[i]} takes \code{i} as samples, whereas \verb{[i,j]}
takes \code{i} as otus and \code{j} as samples (corresponding to \verb{[rows, cols]}
in the underlying \code{biom$counts} matrix).}

\item{drop}{Not used}

\item{object}{An \link[=rbiom_objects]{rbiom object}, such as from \code{\link[=as_rbiom]{as_rbiom()}}.}

\item{fields}{Which metadata field(s) to check for \code{NA}s, or \code{".all"} to
check all metadata fields.}
}
\value{
An \link[=rbiom_objects]{rbiom object}.
}
\description{
Dropping samples or OTUs will lead to observations being removed from the
OTU matrix (\code{biom$counts}). OTUs and samples with zero observations are
automatically removed from the rbiom object.
}
\examples{
    library(rbiom)
    library(dplyr)
    
    # Subset to specific samples
    biom <- hmp50[c('HMP20', 'HMP42', 'HMP12')]
    biom$metadata
    
    # Subset to specific OTUs
    biom <- hmp50[c('LtbAci52', 'UncO2012'),] # <- Trailing ,
    biom$taxonomy
    
    # Subset to specific samples and OTUs
    biom <- hmp50[c('LtbAci52', 'UncO2012'), c('HMP20', 'HMP42', 'HMP12')]
    as.matrix(biom)
    
    # Subset samples according to metadata
    biom <- subset(hmp50, `Body Site` \%in\% c('Saliva') & Age < 25)
    biom$metadata
    
    # Subset OTUs according to taxonomy
    biom <- subset_taxa(hmp50, Phylum == 'Cyanobacteria')
    biom$taxonomy
    
    # Remove samples with NA metadata values
    biom <- mutate(hmp50, BS2 = na_if(`Body Site`, 'Saliva'))
    biom$metadata
    biom <- na.omit(biom)
    biom$metadata

}
\seealso{
Other transformations: 
\code{\link{modify_metadata}},
\code{\link{rarefy}()},
\code{\link{rarefy_cols}()},
\code{\link{slice_metadata}},
\code{\link{with}()}
}
\concept{transformations}
