% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distmat_stats.r
\name{distmat_stats}
\alias{distmat_stats}
\title{Run statistics on a distance matrix vs a categorical or numeric variable.}
\usage{
distmat_stats(dm, groups, test = "adonis2", seed = 0, permutations = 999)
}
\arguments{
\item{dm}{A \code{dist}-class distance matrix, as returned from
\code{\link[=bdiv_distmat]{bdiv_distmat()}} or \code{\link[stats:dist]{stats::dist()}}. Required.}

\item{groups}{A named vector of grouping values. The names should
correspond to \code{attr(dm, 'Labels')}. Values can be either
categorical or numeric. Required.}

\item{test}{Permutational test for accessing significance. Options are:
\describe{
\item{\code{"adonis2"} - }{ Permutational MANOVA; \code{\link[vegan:adonis]{vegan::adonis2()}}. }
\item{\code{"mrpp"} - }{ Multiple response permutation procedure; \code{\link[vegan:mrpp]{vegan::mrpp()}}. }
\item{\code{"none"} - }{ Don't run any statistics. }
}
Abbreviations are allowed. Default: \code{"adonis2"}}

\item{seed}{Random seed for permutations. Default: \code{0}}

\item{permutations}{Number of random permutations to use.
Default: \code{999}}
}
\value{
A data.frame with summary statistics from \code{\link[vegan:permustats]{vegan::permustats()}}.
The columns are:
\describe{
\item{\emph{.n} - }{ The size of the distance matrix. }
\item{\emph{.stat} - }{
The observed statistic. For mrpp, this is the overall
weighted mean of group mean distances. }
\item{\emph{.z} - }{
The difference of observed statistic and mean of permutations
divided by the standard deviation of permutations (also known
as z-values). Evaluated from permuted values without observed
statistic. }
\item{\emph{.p.val} - }{ Probability calculated by \code{test}. }
}
R commands for reproducing the results are in \code{$code}.
}
\description{
Run statistics on a distance matrix vs a categorical or numeric variable.
}
\examples{
    library(rbiom)
    
    hmp10        <- hmp50$clone()
    hmp10$counts <- hmp10$counts[,1:10]
    
    dm <- bdiv_distmat(hmp10, 'unifrac')
    
    distmat_stats(dm, groups = pull(hmp10, 'Body Site'))
    
    distmat_stats(dm, groups = pull(hmp10, 'Age'))
    
    # See the R code used to calculate these statistics:
    stats <- distmat_stats(dm, groups = pull(hmp10, 'Age'))
    stats$code

}
\seealso{
Other beta_diversity: 
\code{\link{bdiv_boxplot}()},
\code{\link{bdiv_clusters}()},
\code{\link{bdiv_corrplot}()},
\code{\link{bdiv_heatmap}()},
\code{\link{bdiv_ord_plot}()},
\code{\link{bdiv_ord_table}()},
\code{\link{bdiv_stats}()},
\code{\link{bdiv_table}()}

Other stats_tables: 
\code{\link{adiv_stats}()},
\code{\link{bdiv_stats}()},
\code{\link{stats_table}()},
\code{\link{taxa_stats}()}
}
\concept{beta_diversity}
\concept{stats_tables}
