% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregation.R
\name{ckde}
\alias{ckde}
\title{Composite Kernel Density Estimates of Radiocarbon Dates}
\usage{
ckde(x, timeRange, bw, normalised = FALSE)
}
\arguments{
\item{x}{A \code{simdates} class object, generated using \code{\link{sampleDates}}.}

\item{timeRange}{A vector of length 2 indicating the start and end date of the analysis in cal BP.}

\item{bw}{Kernel bandwidth to be used.}

\item{normalised}{A logical variable indicating whether the contribution of individual dates should be equal (TRUE), or weighted based on the area under the curve of non-normalised calibration (FALSE). Default is TRUE.}
}
\value{
An object of class \code{ckdeSPD} with the following elements
\itemize{
\item{\code{timeRange}} {The \code{timeRange} setting used.}
\item{\code{res.matrix}} {A matrix containing the KDE values with rows representing calendar dates.}
}
}
\description{
Computes a Composite Kernel Density Estimate (CKDE) from multiple sets of randomly sampled calendar dates.
}
\details{
The function computes Kernel Density Estimates using randomly sampled calendar dates contained in a \code{simdates} class object (generated using the \code{sampledates()} function). The output contains \code{nsim} KDEs, where \code{nsim} is the argument used in \code{simulate.dates()}. The resulting object can be plotted to visualise a CKDE (cf Brown 2017), and if \code{boot} was set to \code{TRUE} in \code{sampleDates} its bootstrapped variant (cf McLaughlin 2018 for a similar analysis). The shape of the CKDE is comparable to an SPD generated from non-normalised dates when the argument \code{normalised} is set to FALSE.
}
\examples{
\dontrun{
data(emedyd)
x = calibrate(x=emedyd$CRA, errors=emedyd$Error,normalised=FALSE)
bins = binPrep(sites=emedyd$SiteName, ages=emedyd$CRA,h=50)
s = sampleDates(x,bins=bins,nsim=100,boot=FALSE)
ckdeNorm = ckde(s,timeRange=c(16000,9000),bw=100,normalised=TRUE)
plot(ckdeNorm,type='multiline',calendar='BCAD')
}

}
\references{
Brown, W. A. 2017. The past and future of growth rate estimation in demographic temporal frequency analysis: Biodemographic interpretability and the ascendance of dynamic growth models. \emph{Journal of Archaeological Science}, 80: 96–108. DOI: https://doi.org/10.1016/j.jas.2017.02.003 \cr
McLaughlin, T. R. 2018. On Applications of Space–Time Modelling with Open-Source 14C Age Calibration. \emph{Journal of Archaeological Method and Theory}. DOI https://doi.org/10.1007/s10816-018-9381-3
}
\seealso{
\code{\link{sampleDates}}
}
