% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ocs.R
\name{ocs_modify_share}
\alias{ocs_modify_share}
\title{Modifies properties of a share}
\usage{
ocs_modify_share(
  req,
  id,
  password = NULL,
  permissions = NULL,
  public_upload = NULL,
  expire_date = NULL,
  label = NULL,
  note = NULL,
  send_mail = NULL,
  attributes = NULL
)
}
\arguments{
\item{req}{WebDAV request as returned by \code{\link{wd_connect}}}

\item{id}{share id}

\item{password}{optional password for link and e-mail shares}

\item{permissions}{integer (1:read, 2:modify, 4:, 8:, 16:share)}

\item{public_upload}{TRUE if public upload should be enabled}

\item{expire_date}{expiration date as string in the format YYYY-MM-DD}

\item{label}{label for the share}

\item{note}{note for the share}

\item{send_mail}{if TRUE the user is notified via e-mail}

\item{attributes}{optional attributes}
}
\value{
data.frame with the share properties
}
\description{
If a parameter omitted or is \code{NULL}, then the coresponding property is not
modified.
}
\examples{
\dontrun{
r <- wd_connect("https://example.com/remote.php/dav/files/johndoe")
ocs_modify_share(r, 12345, permissions = 31, expire_date = "2025-11-01")
}

}
