% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/effects.R
\name{event}
\alias{event}
\title{event}
\usage{
event(x, variableName = NULL)
}
\arguments{
\item{x}{vector with the event attribute}

\item{variableName}{optionally, a string indicating the variable name, used
for the dimnames of the output statistics object}
}
\value{
List with all information required by `remstats::remstats()` to 
compute the statistic.
}
\description{
Specifies the statistic for an "event" effect in the tie-oriented model. An
"event" effect refers to an exogenous event attribute that affects the
waiting time between events.
}
\details{
The statistic at timepoint \emph{t} is for all dyads in the risk set equal
to the attribute of the event at timepoint \emph{t}.
}
\examples{
\donttest{
  reh_tie <- remify::remify(history, model = "tie")
  data(history, package = "remstats")
  history$work <- ifelse(history$setting == "work", 1, 0)
  effects <- ~ event(x = history$work, variableName = "setting_is_work")
  remstats(reh = reh_tie, tie_effects = effects)
}

}
\seealso{
\code{\link{FEtype}}
}
