% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/messages.R
\name{messageDF}
\alias{messageDF}
\alias{messagePrepInputs}
\alias{messagePreProcess}
\alias{messageCache}
\alias{messageQuestion}
\alias{.messageFunctionFn}
\alias{messageColoured}
\title{Use \code{message} with a consistent use of \code{verbose}}
\usage{
messageDF(
  df,
  round,
  colour = NULL,
  colnames = NULL,
  indent = NULL,
  verbose = getOption("reproducible.verbose"),
  verboseLevel = 1,
  appendLF = TRUE
)

messagePrepInputs(
  ...,
  appendLF = TRUE,
  verbose = getOption("reproducible.verbose"),
  verboseLevel = 1
)

messagePreProcess(
  ...,
  appendLF = TRUE,
  verbose = getOption("reproducible.verbose"),
  verboseLevel = 1
)

messageCache(
  ...,
  colour = getOption("reproducible.messageColourCache"),
  verbose = getOption("reproducible.verbose"),
  verboseLevel = 1,
  appendLF = TRUE
)

messageQuestion(..., verboseLevel = 0, appendLF = TRUE)

.messageFunctionFn(
  ...,
  appendLF = TRUE,
  verbose = getOption("reproducible.verbose"),
  verboseLevel = 1
)

messageColoured(
  ...,
  colour = NULL,
  indent = NULL,
  hangingIndent = TRUE,
  verbose = getOption("reproducible.verbose", 1),
  verboseLevel = 1,
  appendLF = TRUE
)
}
\arguments{
\item{df}{A data.frame, data.table, matrix}

\item{round}{An optional numeric to pass to \code{round}}

\item{colour}{Any colour that can be understood by \code{crayon}}

\item{colnames}{Logical or \code{NULL}. If \code{TRUE}, then it will print
column names even if there aren't any in the \code{df} (i.e., they will)
be \code{V1} etc., \code{NULL} will print them if they exist, and \code{FALSE}
which will omit them.}

\item{indent}{An integer, indicating whether to indent each line}

\item{verbose}{Numeric, -1 silent (where possible), 0 being very quiet,
1 showing more messaging, 2 being more messaging, etc.
Default is 1. Above 3 will output much more information about the internals of
Caching, which may help diagnose Caching challenges. Can set globally with an
option, e.g., \verb{options('reproducible.verbose' = 0) to reduce to minimal}}

\item{verboseLevel}{The numeric value for this \verb{message*} call, equal or above
which \code{verbose} must be. The higher this is set, the more unlikely the call
will show a message.}

\item{appendLF}{logical: should messages given as a character string
    have a newline appended?}

\item{...}{Any character vector, passed to \code{paste0(...)}}

\item{hangingIndent}{Logical. If there are \verb{\\n}, should there be a handing indent of 2 spaces.
Default is \code{TRUE}}
}
\value{
Used for side effects. This will produce a message of a structured \code{data.frame}.
}
\description{
This family has a consistent use of \code{verbose} allowing messages to be
turned on or off or verbosity increased or decreased throughout the family of
messaging in \code{reproducible}.
}
\details{
\itemize{
\item \code{messageDF} uses \code{message} to print a clean square data structure.
\item \code{messageColoured} allows specific colours to be used.
\item \code{messageQuestion} sets a high level for \code{verbose} so that the message always gets asked.
}
}
