% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gen_objects2stat.R
\name{gen_objects2stat}
\alias{gen_objects2stat}
\title{gen_objects2stat}
\usage{
gen_objects2stat(
  code = NULL,
  database = c("all", "genesis", "zensus", "regio"),
  category = c("tables", "variables", "cubes"),
  area = c("all", "public", "user"),
  detailed = FALSE,
  sortcriterion = c("code", "content"),
  error.ignore = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{code}{Character string with a maximum length of 6 characters (15 characters if 'cubes' are not used as a category). Code from a GENESIS, Zensus 2022 or regionalstatistik.de object. Only one code per iteration.}

\item{database}{Character string. Indicator if the GENESIS ('genesis'), Zensus 2022 ('zensus') or regionalstatistik.de ('regio') database is called. Default option is 'all'.}

\item{category}{Character string. Specify specific GENESIS/regionalstatistik.de object types ('tables', 'statistics' and 'cubes') and specific Zensus 2022 object types ('tables' and 'statistics'). All types that are specific for one database can be used together. Default option is to use all types that are possible for the specific database.}

\item{area}{Character string. Indicator from which area of the database the results are called. In general, 'all' is the appropriate solution. Default option is 'all'. Not used for 'statistics'.}

\item{detailed}{Boolean. Indicator if the function should return the detailed output of the iteration including all object-related information or only a shortened output including only code and object title. Default option is 'FALSE'.}

\item{sortcriterion}{Character string. Indicator if the output should be sorted by 'code' or 'content'. This is a parameter of the API call itself. The default is 'code'.}

\item{error.ignore}{Boolean. Indicator if the function should stop if an error occurs or no object for the request is found or if it should produce a token as response. Default option is 'FALSE'.}

\item{verbose}{Boolean. Indicator if the output of the function should include detailed messages and warnings. Default option is 'TRUE'. Set the parameter to 'FALSE' to suppress additional messages and warnings.}

\item{...}{Additional parameters for the API call. These parameters are only affecting the call itself, no further processing. For more details see \code{vignette("additional_parameter")}.}
}
\value{
A list with all recalled elements from the API. Based on the 'detailed' parameter it contains more or less information, but always includes the code of the object, the title, and the type of the object. This is done to facilitate further processing with the data. Attributes are added to the data.frame describing the search configuration for the returned output.
}
\description{
Function to find objects related to a statistic
}
\examples{
\dontrun{
# Find cubes from the statistic with the code "21111" with a detailed return
 object <- gen_objects2stat(code = "21111", category = "cubes", detailed = T)

# Find all object types from the statistic with the code "12411"
object <- gen_objects2stat(code = "12411")
# Default of detailed-parameter is FALSE, and default of the
# category-parameter is to include all object types.
}

}
