% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lc.R
\name{getMarked}
\alias{getMarked}
\title{Get currently marked elements}
\usage{
getMarked(chartId = NULL, layerId = NULL, sessionId = NULL)
}
\arguments{
\item{chartId}{An ID of the chart. This argument is optional if there is only one chart.}

\item{layerId}{An ID of the layer. This argument is optional if there is only one chart with
a single layer.}

\item{sessionId}{An ID of the session from which to get the marked elements. It can be \code{NULL}
if there is only one active session. Otherwise must be a valid session ID. Check \code{\link[jrc]{Session}}
for more information on client sessions. If a call to this function was triggered from a web page, the ID of
the corresponding session would be used automatically.}
}
\value{
a vector of indices or, in the case of heatmaps, an \emph{n x 2} matrix where first and
second columns contain row and column indices of the marked cells, respectively.
}
\description{
\code{getMarked} returns indices of the chart's elements that are currently
marked. To mark elements select them with your mouse while holding the \emph{Shift} key.
Double click on the chart with the \emph{Shift} key pressed will deselect all the
elements. This function is a wrapper of method \code{getMarked} of class \code{\link{LCApp}}.
}
\examples{
\dontrun{data(iris)

lc_scatter(dat(x = iris$Sepal.Length, y = iris$Petal.Length))

#now mark some points by selecting them with your mouse with Shift pressed

getMarked("Chart1")}

}
