% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model-table.R
\name{mdl_tbl}
\alias{mdl_tbl}
\alias{model_table}
\alias{is_model_table}
\title{Model tables}
\usage{
mdl_tbl(..., data = NULL)

model_table(..., data = NULL)

is_model_table(x)
}
\arguments{
\item{...}{Named or unnamed \code{mdl} or \code{fmls} objects}

\item{data}{A \code{data.frame} or \code{tbl_df} object, named correspondingly to
the underlying data used in the models (to help match)}

\item{x}{A \code{mdl_tbl} object}
}
\value{
A \code{mdl_tbl} object, which is essentially a \code{data.frame} with
additional information on the relevant data, terms, and formulas used to
generate the models.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

The \code{model_table()} or \code{mdl_tbl()} function creates a \code{mdl_tbl} object that
is composed of either \code{fmls} objects or \code{mdl} objects, which are
thin/informative wrappers for generic formulas and hypothesis-based models.
The \code{mdl_tbl} is a data frame of model information, such as model fit,
parameter estimates, and summary statistics about a model, or a formula if it
has not yet been fit.
}
\details{
The table itself allows for ease of organization of model information and has
three additional, major components (stored as scalar attributes).
\enumerate{
\item A formula matrix that describes the terms used in each model, and how they
are combined.
\item A term table that describes the terms and their properties and/or labels.
\item A list of datasets used for the analyses that can help support additional diagnostic testing.
}

We go into further detail in the sections below.
}
\section{Data List}{
NA
}

\section{Term Table}{
NA
}

\section{Formula Matrix}{
NA
}

