% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmw_predict_nested_sets_by_year.R
\name{rmw_predict_nested_sets_by_year}
\alias{rmw_predict_nested_sets_by_year}
\title{Function to make predictions by meteorological year from a random forest 
models using a nested tibble.}
\usage{
rmw_predict_nested_sets_by_year(
  df_nest,
  variables = NA,
  n_samples = 10,
  aggregate = TRUE,
  n_cores = NULL,
  verbose = FALSE
)
}
\arguments{
\item{df_nest}{Nested tibble created by \code{\link{rmw_model_nested_sets}}.}

\item{variables}{Variables to randomly sample. Default is all variables used
for training the model with the exception of \code{date_unix}, the trend term.}

\item{n_samples}{Number of times to sample the observations from each 
meteorological year and then predict.}

\item{aggregate}{Should all the \code{n_samples} predictions be aggregated?}

\item{n_cores}{Number of CPU cores to use for the model calculations.}

\item{verbose}{Should the function give messages?}
}
\value{
Nested tibble.
}
\description{
Function to make predictions by meteorological year from a random forest 
models using a nested tibble.
}
\seealso{
\code{\link{rmw_nest_for_modelling}}, 
\code{\link{rmw_model_nested_sets}}
}
\author{
Stuart K. Grange
}
