% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ssimEnvironment.R
\name{progressBar}
\alias{progressBar}
\title{Sets the progress bar in the SyncroSim User Interface}
\usage{
progressBar(
  type = "step",
  iteration = NULL,
  timestep = NULL,
  totalSteps = NULL,
  message
)
}
\arguments{
\item{type}{character. Update to apply to progress bar. Options include
"begin", "end", "step", "report", and "message" (Default is "step")}

\item{iteration}{integer. The current iteration. Only used if
\code{type = "report"}}

\item{timestep}{integer. The current timestep. Only used if
\code{type = "report"}}

\item{totalSteps}{integer. The total number of steps in the simulation. Only
used if \code{type = "begin"}}

\item{message}{character. An arbitrary messsage to be printed to the status
bar. Only used if \code{type = "message"}.}
}
\value{
No returned value, used for side effects
}
\description{
This function is designed to facilitate the development of R-based Syncrosim
Packages, such as beginning, stepping, ending, and reporting the progress
for a SyncroSim simulation.
}
\examples{
\dontrun{
# Begin the progress bar for a simulation
progressBar(type = "begin", totalSteps = numIterations * numTimesteps)

# Increase the progress bar by one step for a simulation
progressBar(type = "step")

# Report progress for a simulation
progressBar(type = "report", iteration = iter, timestep = ts)

# Report arbitrary progress message 
progressBar(type = "message", message = msg)

# End the progress bar for a simulation
progressBar(type = "end")
}

}
