% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{beta_function}
\alias{beta_function}
\title{Beta function}
\usage{
beta_function(k, K, w1, w2)
}
\arguments{
\item{k}{Lag of interest.}

\item{K}{Number of (lagged) realizations to consider.}

\item{w1, w2}{Parameters governing the weights of each \eqn{k} lag.}
}
\value{
The weights associated to each lag \eqn{k}, with \eqn{k=1,\cdots,K}.
}
\description{
Represents a tool able to accommodate various lag structures for the
additional MIDAS variable observed each "low-frequency" period \eqn{t}. It can have a monotonically increasing,
decreasing weighting scheme or a hump-shaped weighting scheme. The Beta function is:
\deqn{\delta_k(\omega)=\frac{(k/K)^{\omega_1-1} (1-k/K)^{\omega_2-1}}{\sum_{j=1}^K (j/K)^{\omega_1-1}(1-j/K)^{\omega_2-1}}.}
For additional details, see \insertCite{ghysels_2007;textual}{rumidas}.
}
\examples{
# suppose to have four lags: 
# K<-4 
# w1<-1	# by setting w1=1, only a monotonically decreasing weighting scheme is allowed
	#(more recent observations weigh more)
# w2<-5
beta_function(1:4,K=4,w1=1,w2=5)
}
\references{
\insertAllCited{}
}
