#' Ensembl Mito IDs
#'
#' A list of ensembl ids for mitochondrial genes (Ensembl version 112; 4/29/2024)
#'
#' @format A list of six vectors
#' \describe{
#'   \item{Mus_musculus_mito_ensembl}{Ensembl IDs for mouse mitochondrial genes}
#'   \item{Homo_sapiens_mito_ensembl}{Ensembl IDs for human mitochondrial genes}
#'   \item{Danio_rerio_mito_ensembl}{Ensembl IDs for zebrafish mitochondrial genes}
#'   \item{Rattus_norvegicus_mito_ensembl}{Ensembl IDs for rat mitochondrial genes}
#'   \item{Drosophila_melanogaster_mito_ensembl}{Ensembl IDs for fly mitochondrial genes}
#'   \item{Macaca_mulatta_mito_ensembl}{Ensembl IDs for macaque mitochondrial genes}
#'   \item{Gallus_gallus_mito_ensembl}{Ensembl IDs for chicken mitochondrial genes}
#' }
#' @concept data
#' @source See data-raw directory for scripts used to create gene list.
#'
#'
"ensembl_mito_id"


#' Ensembl Ribo IDs
#'
#' A list of ensembl ids for ribosomal genes (Ensembl version 112; 4/29/2024)
#'
#' @format A list of eight vectors
#' \describe{
#'   \item{Mus_musculus_ribo_ensembl}{Ensembl IDs for mouse ribosomal genes}
#'   \item{Homo_sapiens_ribo_ensembl}{Ensembl IDs for human ribosomal genes}
#'   \item{Callithrix_jacchus_ribo_ensembl}{Ensembl IDs for marmoset ribosomal genes}
#'   \item{Danio_rerio_ribo_ensembl}{Ensembl IDs for zebrafish ribosomal genes}
#'   \item{Rattus_norvegicus_ribo_ensembl}{Ensembl IDs for rat ribosomal genes}
#'   \item{Drosophila_melanogaster_ribo_ensembl}{Ensembl IDs for fly ribosomal genes}
#'   \item{Macaca_mulatta_ribo_ensembl}{Ensembl IDs for macaque ribosomal genes}
#'   \item{Gallus_gallus_ribo_ensembl}{Ensembl IDs for chicken ribosomal genes}
#' }
#' @concept data
#' @source See data-raw directory for scripts used to create gene list.
#'
"ensembl_ribo_id"


#' Ensembl Hemo IDs
#'
#' A list of ensembl ids for hemoglobin genes (Ensembl version 112; 4/29/2024)
#'
#' @format A list of six vectors
#' \describe{
#'   \item{Mus_musculus_hemo_ensembl}{Ensembl IDs for mouse hemoglobin genes}
#'   \item{Homo_sapiens_hemo_ensembl}{Ensembl IDs for human hemoglobin genes}
#'   \item{Danio_rerio_hemo_ensembl}{Ensembl IDs for zebrafish hemoglobin genes}
#'   \item{Rattus_norvegicus_hemo_ensembl}{Ensembl IDs for rat hemoglobin genes}
#'   \item{Drosophila_melanogaster_hemo_ensembl}{Ensembl IDs for fly hemoglobin genes}
#'   \item{Macaca_mulatta_hemo_ensembl}{Ensembl IDs for macaque hemoglobin genes}
#'   \item{Gallus_gallus_ribo_ensembl}{Ensembl IDs for chicken hemoglobin genes}
#' }
#' @concept data
#' @source See data-raw directory for scripts used to create gene list.
#'
#'
"ensembl_hemo_id"


#' QC Gene Lists
#'
#' Gene symbols for qc percentages from MSigDB database.  The gene sets are from 3 MSigDB lists:
#' "HALLMARK_OXIDATIVE_PHOSPHORYLATION", "HALLMARK_APOPTOSIS", and "HALLMARK_DNA_REPAIR".
#'
#' @format A list of 21 vectors
#' \describe{
#'   \item{Homo_sapiens_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for human}
#'   \item{Homo_sapiens_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for human}
#'   \item{Homo_sapiens_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for human}
#'   \item{Mus_musculus_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for mouse}
#'   \item{Mus_musculus_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for mouse}
#'   \item{Mus_musculus_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for mouse}
#'   \item{Rattus_norvegicus_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for rat}
#'   \item{Rattus_norvegicus_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for rat}
#'   \item{Rattus_norvegicus_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for rat}
#'   \item{Drosophila_melanogaster_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for fly}
#'   \item{Drosophila_melanogaster_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for fly}
#'   \item{Drosophila_melanogaster_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for fly}
#'   \item{Dario_rerio_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for zebrafish}
#'   \item{Dario_rerio_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for zebrafish}
#'   \item{Dario_rerio_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for zebrafish}
#'   \item{Macaca_mulatta_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for macaque}
#'   \item{Macaca_mulatta_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for macaque}
#'   \item{Macaca_mulatta_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for macaque}
#'   \item{Gallus_gallus_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for chicken}
#'   \item{Gallus_gallus_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for chicken}
#'   \item{Gallus_gallus_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for chicken}
#' }
#' @concept data
#'
#' @source MSigDB gene sets (gene symbols) via msigdbr package \url{https://cran.r-project.org/package=msigdbr}.  See data-raw directory for scripts used to create gene list.
#'
"msigdb_qc_gene_list"


#' QC Gene Lists
#'
#' Ensembl IDs for qc percentages from MSigDB database.  The gene sets are from 3 MSigDB lists:
#' "HALLMARK_OXIDATIVE_PHOSPHORYLATION", "HALLMARK_APOPTOSIS", and "HALLMARK_DNA_REPAIR".
#' (Ensembl version 112; 4/29/2024)
#'
#' @format A list of 21 vectors
#' \describe{
#'   \item{Homo_sapiens_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for human}
#'   \item{Homo_sapiens_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for human}
#'   \item{Homo_sapiens_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for human}
#'   \item{Mus_musculus_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for mouse}
#'   \item{Mus_musculus_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for mouse}
#'   \item{Mus_musculus_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for mouse}
#'   \item{Rattus_norvegicus_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for rat}
#'   \item{Rattus_norvegicus_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for rat}
#'   \item{Rattus_norvegicus_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for rat}
#'   \item{Drosophila_melanogaster_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for fly}
#'   \item{Drosophila_melanogaster_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for fly}
#'   \item{Drosophila_melanogaster_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for fly}
#'   \item{Dario_rerio_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for zebrafish}
#'   \item{Dario_rerio_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for zebrafish}
#'   \item{Dario_rerio_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for zebrafish}
#'   \item{Macaca_mulatta_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for macaque}
#'   \item{Macaca_mulatta_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for macaque}
#'   \item{Macaca_mulatta_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for macaque}
#'   \item{Gallus_gallus_msigdb_oxphos}{Genes in msigdb "HALLMARK_OXIDATIVE_PHOSPHORYLATION" list for chicken}
#'   \item{Gallus_gallus_msigdb_apop}{Genes in msigdb "HALLMARK_APOPTOSIS" list for chicken}
#'   \item{Gallus_gallus_msigdb_dna_repair}{Genes in msigdb "HALLMARK_DNA_REPAIR" list for chicken}
#' }
#' @concept data
#'
#' @source MSigDB gene sets (ensembl IDs) via msigdbr package \url{https://cran.r-project.org/package=msigdbr}.  See data-raw directory for scripts used to create gene list.
#'
"msigdb_qc_ensembl_list"


#' Immediate Early Gene (IEG) gene lists
#'
#' Gene symbols for immediate early genes
#'
#' @format A list of seven vectors
#' \describe{
#'   \item{Mus_musculus_IEGs}{Gene symbols for IEGs from source publication (see below)}
#'   \item{Homo_sapiens_IEGs}{Human gene symbols for homologous genes from mouse gene list}
#'
#' }
#' @concept data
#'
#' @source Mouse gene list is from: SI Table 4 from \doi{10.1016/j.neuron.2017.09.026}.  Human
#' gene list was compiled by first creating homologous gene list using biomaRt and then adding some manually curated
#' homologs according to HGNC.  See data-raw directory for scripts used to create gene list.
#'
"ieg_gene_list"


#' Immediate Early Gene (IEG) gene lists
#'
#' Ensembl IDs for immediate early genes (Ensembl version 112; 4/29/2024)
#'
#' @format A list of seven vectors
#' \describe{
#'   \item{Mus_musculus_IEGs}{Ensembl IDs for IEGs from source publication (see below)}
#'   \item{Homo_sapiens_IEGs}{Ensembl IDs for homologous genes from mouse gene list}
#'
#' }
#' @concept data
#'
#' @source Mouse gene list is from: SI Table 4 from \doi{10.1016/j.neuron.2017.09.026}.  Human
#' gene list was compiled by first creating homologous gene list using biomaRt and then adding some manually curated
#' homologs according to HGNC.  See data-raw directory for scripts used to create gene list.
#'
"ensembl_ieg_list"


#' MALAT1 gene lists
#'
#' Ensembl IDs for MALAT1 (Ensembl version 112; 4/29/2024)
#'
#' @format A list of seven vectors
#' \describe{
#'   \item{Mus_musculus_MALAT1_ensembl}{Ensembl ID for mouse Malat1}
#'   \item{Homo_sapiens_MALAT1_ensembl}{Ensembl ID for human MALAT1}
#'
#' }
#' @concept data
#'
#' @source See data-raw directory for scripts used to create gene list.
#'
"ensembl_malat1_list"


#' exAM gene lists
#'
#' Gene symbols for exAM genes
#'
#' @format A list of three vectors
#' \describe{
#'   \item{Mus_musculus_exAM_union}{Gene symbols for exAM genes from source publication (see below)}
#'   \item{Homo_sapiens_exAM_union}{Human gene symbols for homologous genes from mouse gene list}
#'   \item{Homo_sapiens_exAM_micro}{Human gene symbols for human microglia list}
#'
#' }
#' @concept data
#'
#' @source Gene list is from: SI Table 22 Marsh et al., 2022 (Nature Neuroscience) from \doi{10.1038/s41593-022-01022-8}.
#' See data-raw directory for scripts used to create gene list.
#'
"exAM_gene_list"


#' Immediate Early Gene (IEG) gene lists
#'
#' Ensembl IDs for immediate early genes (Ensembl version 112; 4/29/2024)
#'
#' @format A list of three vectors
#' \describe{
#'   \item{Mus_musculus_exAM_union_ensembl}{Ensembl ID for exAM genes from source publication (see below)}
#'   \item{Homo_sapiens_exAM_union_ensembl}{Human Ensembl ID for exAM genes for homologous genes from mouse gene list}
#'   \item{Homo_sapiens_exAM_micro_ensembl}{Human Ensembl ID for exAM genes for human microglia list}
#'
#' }
#' @concept data
#'
#' @source Gene list is from: SI Table 22 Marsh et al., 2022 (Nature Neuroscience) from \doi{10.1038/s41593-022-01022-8}.
#' See data-raw directory for scripts used to create gene list.
#'
"ensembl_exAM_list"


#' Ensembl lncRNA IDs
#'
#' A list of ensembl ids for lncRNA genes (Ensembl version 113; 04/08/2025)
#'
#' @format A list of seven vectors
#' \describe{
#'   \item{Mus_musculus_lncRNA_ensembl}{Ensembl IDs for mouse lncRNA genes}
#'   \item{Homo_sapiens_lncRNA_ensembl}{Ensembl IDs for human lncRNA genes}
#'   \item{Callithrix_jacchus_lncRNA_ensembl}{Ensembl IDs for marmoset lncRNA genes}
#'   \item{Danio_rerio_lncRNA_ensembl}{Ensembl IDs for zebrafish lncRNA genes}
#'   \item{Rattus_norvegicus_lncRNA_ensembl}{Ensembl IDs for rat lncRNA genes}
#'   \item{Macaca_mulatta_lncRNA_ensembl}{Ensembl IDs for macaque lncRNA genes}
#'   \item{Gallus_gallus_lncRNA_ensembl}{Ensembl IDs for chicken lncRNA genes}
#' }
#' @concept data
#' @source See data-raw directory for scripts used to create gene list.
#'
#'
"ensembl_lncRNA_id"


#' lncRNA gene list
#'
#' A list of gene symbol ids for lncRNA genes (Ensembl version 113; 04/08/2025)
#'
#' @format A list of six vectors
#' \describe{
#'   \item{Mus_musculus_lncRNA}{Ensembl IDs for mouse lncRNA genes}
#'   \item{Homo_sapiens_lncRNA}{Ensembl IDs for human lncRNA genes}
#'   \item{Danio_rerio_lncRNA}{Ensembl IDs for zebrafish lncRNA genes}
#'   \item{Rattus_norvegicus_lncRNA}{Ensembl IDs for rat lncRNA genes}
#'   \item{Macaca_mulatta_lncRNA}{Ensembl IDs for macaque lncRNA genes}
#'   \item{Gallus_gallus_lncRNA}{Ensembl IDs for chicken lncRNA genes}
#' }
#' @concept data
#' @source See data-raw directory for scripts used to create gene list.
#'
#'
"lncRNA_gene_list"
