% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Plotting_Nebulosa.R
\name{Plot_Density_Custom}
\alias{Plot_Density_Custom}
\title{Nebulosa Density Plot}
\usage{
Plot_Density_Custom(
  seurat_object,
  features,
  joint = FALSE,
  viridis_palette = "magma",
  custom_palette = NULL,
  pt.size = 1,
  aspect_ratio = NULL,
  reduction = NULL,
  combine = TRUE,
  ...
)
}
\arguments{
\item{seurat_object}{Seurat object name.}

\item{features}{Features to plot.}

\item{joint}{logical. Whether to return joint density plot. Default is FALSE.}

\item{viridis_palette}{default viridis palette to use (must be one of: "viridis", "magma", "cividis",
"inferno", "plasma").  Default is "magma".}

\item{custom_palette}{non-default color palette to be used in place of default viridis options.}

\item{pt.size}{Adjust point size for plotting.}

\item{aspect_ratio}{Control the aspect ratio (y:x axes ratio length).  Must be numeric value;
Default is NULL.}

\item{reduction}{Dimensionality Reduction to use (if NULL then defaults to Object default).}

\item{combine}{Create a single plot? If FALSE, a list with ggplot objects is returned.}

\item{...}{Extra parameters passed to \code{\link[Nebulosa]{plot_density}}.}
}
\value{
A ggplot object
}
\description{
Allow for customization of Nebulosa plot_density.  Requires Nebulosa package from Bioconductor.
}
\examples{
\dontrun{
library(Seurat)
Plot_Density_Custom(seurat_object = pbmc_small, features = "CD3E")
}

}
\concept{other_seurat_plotting}
