# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @noRd
#' @describeIn evaltape_internal The value of a recorded function approximated by Taylor expansion.
#' Returns the approximate value of `pfun` at `x`.
#' @details
#' # pTaylorApprox 
#' Approximates the value of a `CppAD` tape at `x` using a Taylor approximation at `centre`. The dynamic parameters of the tape are set by `dynparam`.
#' @param centre For pTaylorApprox. A vector in the domain of the taped function to approximate the value at `x` from.
#' @param order For pTaylorApprox. The order of Taylor expansion to use.
pTaylorApprox <- function(pfun, x, centre, dynparam, order) {
    .Call('_scorematchingad_pTaylorApprox', PACKAGE = 'scorematchingad', pfun, x, centre, dynparam, order)
}

#' @noRd
#' @name evaltape_internal
#' @title Advanced: Evaluate `CppAD` Tapes via their Pointer
#' @description The recommended method for evaluating tapes is [`evaltape()`].
#' Internally, `evaltape()` and other methods are using the methods documented here.
#' There methods access the tapes using `Rcpp::XPtr` objects and perform evaluations a single point at a time. 
#' @return A vector of numeric values, except `pParameter()`, which returns logical values.
#' @family tape evaluators
#' @param pfun Rcpp::XPtr to an ADFun. Can be obtained as the `ptr` field of an [`ADFun`] object.
#' @param x A vector in the domain of the taped function
#' @param dynparam a vector of the dynamic parameters, if `pfun` has no dynamic parameter than pass `vector("numeric")`.
NULL

#' @noRd
#' @describeIn evaltape_internal Evaluates a tape without any differentiation at the given values of `x` and dynparam. 
#' The name `pForward0` is a reference to the zero order `CppAD` method [`forward`](https://cppad.readthedocs.io/forward_zero.html), and the prefix 'p' is because the tape is passed as a pointer.
#' @param pfun Rcpp::XPtr to an ADFun. Can be obtained as the `ptr` field of an [`ADFun`] object.
#' @param x A vector in the domain of the taped function
#' @param dynparam a vector of the dynamic parameters, if `pfun` has no dynamic parameter than pass `vector("numeric")`.
pForward0 <- function(pfun, x, dynparam) {
    .Call('_scorematchingad_pForward0', PACKAGE = 'scorematchingad', pfun, x, dynparam)
}

#' @noRd
#' @describeIn evaltape_internal Evaluates a the Jacobian of a tape using the `CppAD` `Jacobian` method <https://cppad.readthedocs.io/latest/Jacobian.html>. 
pJacobian <- function(pfun, x, dynparam) {
    .Call('_scorematchingad_pJacobian', PACKAGE = 'scorematchingad', pfun, x, dynparam)
}

#' @noRd
#' @describeIn evaltape_internal Evaluates a the Hessian of a tape using the `CppAD` `Hessian` method <https://cppad.readthedocs.io/latest/Hessian.html>, assuming that range space of the taped function has dimension of `1`. 
pHessian <- function(pfun, x, dynparam) {
    .Call('_scorematchingad_pHessian', PACKAGE = 'scorematchingad', pfun, x, dynparam)
}

#' @noRd
#' @describeIn evaltape_internal Test whether the returned values are constant with respect to the independent values using 
#' `CppAD`'s `Parameter` method <https://cppad.readthedocs.io/latest/fun_property.html>.
#' Returns A vector of logical values. `TRUE` indicates that element of the tape result is constant.
#' @details 
#' # pParameter
#' The `CppAD` function [`Parameter(i)`](https://cppad.readthedocs.io/latest/fun_property.html#parameter) returns `TRUE` when the `i`th component of the range does not depend on the independent value
#' (the `i`th component may still depend on the value of the dynamic parameters - see <https://cppad.readthedocs.io/latest/glossary.html#dynamic> ).
pParameter <- function(pfun) {
    .Call('_scorematchingad_pParameter', PACKAGE = 'scorematchingad', pfun)
}

#' @noRd
#' @title Tape the Jacobian of CppAD Tape
#' @family tape builders
#' @param pfun Rcpp::XPtr to an ADFun tape a tape with dynamic parameters and independent parameters
#' @param x A vector in the domain of the taped function.
#' @param dynparam a vector of the dynamic parameters
#' @description Creates a tape of the Jacobian of function taped by CppAD.
#' When the function returns a real value (as is the case for densities and the score matching objective) the Jacobian is equivalent to the gradient.
#' The `x` vector is used as the value to conduct the taping.
#' @details
#' When the returned tape is evaluated (via say [`pForward0()`], the resultant vector contains the Jacobian in long format (see <https://cppad.readthedocs.io/latest/Jacobian.html>).
#' Suppose the function represented by `pfun` maps from \eqn{n}-dimensional space to \eqn{m}-dimensional space, then
#' the first \eqn{n} elements of vector is the gradient of the first component of function output.
#' The next \eqn{n} elements of the vector is the gradient of the second component of the function output.
#' The Jacobian as a matrix, could then be obtained by [`as.matrix()`] with `byrow = TRUE` and `ncol = n`.
#' @return A `Rcpp::XPtr` to a CppAD::ADFun object.
pTapeJacobian <- function(pfun, x, dynparam) {
    .Call('_scorematchingad_pTapeJacobian', PACKAGE = 'scorematchingad', pfun, x, dynparam)
}

#' @noRd
#' @title Tape the Hessian of a CppAD Tape
#' @family tape builders
#' @inheritParams pTapeJacobian
#' @description Creates a tape of the Hessian of a function taped by CppAD.
#' The taped function represented by `pfun` must be scalar-valued (i.e. a vector of length 1).
#' The `x` vector and `dynparam` are used as the values to conduct the taping.
#' @details
#' When the returned tape is evaluated (via say [`pForward0()`], the resultant vector contains the Hessian in long format (see <https://cppad.readthedocs.io/latest/Hessian.html>).
#' Suppose the function represented by `pfun` maps from \eqn{n}-dimensional space to \eqn{1}-dimensional space, then
#' the first \eqn{n} elements of the vector is the gradient of the partial derivative with respect to the first dimension of the function's domain.
#' The next \eqn{n} elements of the vector is the gradient of the partial derivative of the second dimension of the function's domain.
#' The Hessian as a matrix, can be obtained by using [`as.matrix()`] with `ncol = n`.
#' @return A `Rcpp::XPtr` to a CppAD::ADFun object.
pTapeHessian <- function(pfun, x, dynparam) {
    .Call('_scorematchingad_pTapeHessian', PACKAGE = 'scorematchingad', pfun, x, dynparam)
}

#' @noRd
#' @title Tape the Gradient Offset of a Quadratic CppAD Tape
#' @family tape builders
#' @inheritParams pTapeJacobian
#' @return A `Rcpp::XPtr` to a CppAD::ADFun object. The independent argument to the function are the dynamic parameters of `pfun`.
#' @details A quadratic function can be written as
#' \deqn{f(x;\theta) = \frac{1}{2} x^T W(\theta) x + b(\theta)^Tx + c.}
#' The gradient of \eqn{f(x; \theta)} with respect to \eqn{x} is
#' \deqn{\Delta f(x; \theta) = \frac{1}{2}(W(\theta) + W(\theta)^T)x + b(\theta).}
#' The Hessian is 
#' \deqn{H f(x; \theta) = \frac{1}{2}(W(\theta) + W(\theta)^T),}
#' which does not depend on \eqn{x},
#' so the gradient of the function can be rewritten as
#' \deqn{\Delta f(x;\theta) = H f(x; \theta) x + b(\theta)^T.}
#' The tape calculates \eqn{b(\theta)} as
#'  \deqn{b(\theta) = \Delta f(x;\theta) - H f(x; \theta) x,}
#' which does not depend on \eqn{x}.
pTapeGradOffset <- function(pfun, x, dynparam) {
    .Call('_scorematchingad_pTapeGradOffset', PACKAGE = 'scorematchingad', pfun, x, dynparam)
}

#' @noRd
#' @title Tape the log of Jacobian determinant of a CppAD Tape
#' @family tape builders
#' @param pfun Rcpp::XPtr to an ADFun tape a tape with dynamic parameters and independent parameters
#' @param x A vector in the domain of the taped function.
#' @param dynparam a vector of the dynamic parameters
#' @description Creates a tape of the log of the Jacobian determinant of a function taped by CppAD.
#' The `x` vector is used as the value to conduct the taping.
#' @return A `Rcpp::XPtr` to a CppAD::ADFun object.
ptapelogdetJ <- function(pfun, x, dynparam) {
    .Call('_scorematchingad_ptapelogdetJ', PACKAGE = 'scorematchingad', pfun, x, dynparam)
}

#' @noRd
#' @title Switch Dynamic and Independent Values of a Tape
#' @family tape builders
#' @description Convert an ADFun so that the independent values become dynamic parameters
#' and the dynamic parameters become independent values
#' @param pfun An Rcpp::XPtr to an ADFun object (i.e. a tape of a function)
#' @param newvalue The independent value (in the sense after the switch has occurred) at which to tape the ADFun
#' @param newdynparam The value of the dynamic parameters (after the switch) at which to tape the ADFun
#' @return A pointer to an ADFun
swapDynamic <- function(pfun, newvalue, newdynparam) {
    .Call('_scorematchingad_swapDynamic', PACKAGE = 'scorematchingad', pfun, newvalue, newdynparam)
}

#' @name evalll
#' @title Evaluate a custom log-likelihood function
#' @description Evaluates a custom log-likelihood function from [`customll()`] without taping. This is useful to check that the custom log-likelihood is behaving.
#' To check a tape of the custom log-likelihood use [`buildsmdtape()`] then [`evaltape()`].
#' @param ll A compiled log-likelihood function created by [`customll()`].
NULL

#' @noRd
#' @title Tape of a log-likelihood calculation 2
#' @param p dimension of measurements
#' @param bd dimension of the parameter vector
#' @param llname name of the likelihood function
#' @return An RCpp::XPtr object pointing to the ADFun
ptapell2 <- function(z_ad, theta_ad, llfXPtr, tran, fixedtheta, verbose) {
    .Call('_scorematchingad_ptapell2', PACKAGE = 'scorematchingad', z_ad, theta_ad, llfXPtr, tran, fixedtheta, verbose)
}

#' @noRd
#' @title Get an XPtr to a named log-likelihood function in source code of package
#' @param llname name of the likelihood function
#' @return An RCpp::XPtr object pointing to a `llPtr` object of the log-likelihood function. Since `llPtr` is itself a pointer object, we have an XPtr pointing to a pointer that points to a function.
getllptr <- function(llname) {
    .Call('_scorematchingad_getllptr', PACKAGE = 'scorematchingad', llname)
}

#' @param u A vector of measurements for an individual
#' @param theta A vector of parameters
#' @return The value of the log-likelihood at `u` with parameters `theta`.
#' @export
evalll <- function(ll, u, theta) {
    .Call('_scorematchingad_evalll', PACKAGE = 'scorematchingad', ll, u, theta)
}

#' @noRd
#' @title The score matching objective calculator.
#' @param xbetain a concatenated vector of sqrt(x) and beta
#' @param n The dimension of x.
#' @param manifoldname The name of the manifold to transform to
#' @param weightname The name of the weight function to use
#' @param acut The constraint a_c in the weight function
#' @return An RCpp::XPtr object pointing to the ADFun
ptapesmd <- function(u_ad, theta_ad, pll, tran, man, weightname, acut, verbose) {
    .Call('_scorematchingad_ptapesmd', PACKAGE = 'scorematchingad', u_ad, theta_ad, pll, tran, man, weightname, acut, verbose)
}

