% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_rand_indices}
\alias{get_rand_indices}
\title{Compute Rand indices}
\usage{
get_rand_indices(fit, groundtruth, adjusted = TRUE)
}
\arguments{
\item{fit}{An object of class \code{scregclust}}

\item{groundtruth}{A known clustering of the target genes (integer vector)}

\item{adjusted}{If TRUE, the Adjusted Rand index is computed. Otherwise the
ordinary Rand index is computed.}
}
\value{
A \code{\link{data.frame}} containing the Rand indices. Since there can
be more than one final configuration for some penalization
parameters, Rand indices are averaged for each fixed penalization
parameter. Returned are the mean, standard deviation and number
of final configurations that were averaged.
}
\description{
Compute Rand indices for fitted scregclust object
}
\references{
W. M. Rand (1971). "Objective criteria for the evaluation of clustering
methods". Journal of the American Statistical Association 66 (336): 846–850.
DOI:10.2307/2284239

Lawrence Hubert and Phipps Arabie (1985). "Comparing partitions".
Journal of Classification. 2 (1): 193–218. DOI:10.1007/BF01908075
}
\concept{utilities}
