#' Navigate backwards
#'
#'\code{back} Navigate backwards in the browser history, if possible.
#'
#' @template remDr
#' @template ellipsis
#'
#' @family navigation functions
#' @template ret1
#' @export
#'
#' @example /inst/examples/docs/navigation.R
#' @name back
NULL

#' Navigate forwards
#'
#'\code{forward} Navigate forwards in the browser history, if possible.
#'
#' @template remDr
#' @template ellipsis
#'
#' @family navigation functions
#' @template ret1
#' @export
#'
#' @example /inst/examples/docs/navigation.R
#' @name forward
NULL

#' Retrieve the URL of the current page.
#'
#'\code{getCurrentUrl} Retrieve the URL of the current page.
#'
#' @template remDr
#' @template ellipsis
#'
#' @family navigation functions
#' @return A character string is returned giving the current page URL.
#' @export
#'
#' @example /inst/examples/docs/navigation.R
#' @name getCurrentUrl
NULL

#' Get the current page title.
#'
#'\code{getTitle} Get the current page title.
#'
#' @template remDr
#' @template ellipsis
#'
#' @family navigation functions
#' @return The title of the current page is returned as a character string.
#' @export
#'
#' @example /inst/examples/docs/navigation.R
#' @name getTitle
NULL

#' Navigate to a new URL.
#'
#'\code{go} Navigate to a new URL.
#' @template ellipsis
#'
#' @template remDr
#' @param url The URL to navigate to.
#'
#' @family navigation functions
#' @template ret1
#' @export
#'
#' @example /inst/examples/docs/navigation.R
#' @name go
NULL

#' Refresh the current page.
#'
#'\code{refresh} Refresh the current page.
#'
#' @template remDr
#' @template ellipsis
#'
#' @family navigation functions
#' @template ret1
#' @export
#'
#' @example /inst/examples/docs/navigation.R
#' @name refresh
NULL


