% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\name{default_doc_internal}
\alias{default_doc_internal}
\title{Unexported documentation helper function.}
\usage{
default_doc_internal(
  internal,
  model,
  predict_model,
  x_explain,
  x_train,
  n_features,
  W_kernel,
  S,
  dt_vS,
  output_size,
  ...
)
}
\arguments{
\item{internal}{List.
Holds all parameters, data, functions and computed objects used within \code{\link[=explain]{explain()}}
The list contains one or more of the elements \code{parameters}, \code{data}, \code{objects}, \code{iter_list}, \code{timing_list},
\code{main_timing_list}, \code{output}, and \code{iter_timing_list}.}

\item{model}{Objects.
The model object that ought to be explained.
See the documentation of \code{\link[=explain]{explain()}} for details.}

\item{predict_model}{Function.
The prediction function used when \code{model} is not natively supported.
See the documentation of \code{\link[=explain]{explain()}} for details.}

\item{x_explain}{Data.table with the features of the observation whose
predictions ought to be explained (test data).}

\item{x_train}{Data.table with training data.}

\item{n_features}{Positive integer.
The number of features.}

\item{W_kernel}{Numeric matrix. Contains all nonscaled weights between training and test
observations for all coalitions. The dimension equals \verb{n_train x m}.}

\item{S}{Integer matrix of dimension \verb{n_coalitions x m}, where \code{n_coalitions}
and \code{m} equals the total number of sampled/non-sampled coalitions and
the total number of unique features, respectively. Note that \code{m = ncol(x_train)}.}

\item{dt_vS}{Data.table of dimension \code{n_coalitions} times \code{n_explain + 1} containing the contribution function
estimates. The first column is assumed to be named \code{id_coalition} and containing the ids of the coalitions.
The last row is assumed to be the full coalition, i.e., it contains the predicted responses for the observations
which are to be explained.}

\item{output_size}{Scalar integer.
Specifies the dimension of the output from the prediction model for every observation.}

\item{...}{Further arguments passed to \code{approach}-specific functions.}
}
\value{
The \code{internal} list.
It holds all parameters, data, and computed objects used within \code{\link[=explain]{explain()}}.
}
\description{
Unexported documentation helper function.
}
\keyword{internal}
