% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checking_data.R
\name{agrupar_cols_casos}
\alias{agrupar_cols_casos}
\title{Agrupar por columnas y casos}
\usage{
agrupar_cols_casos(data_event, nomb_cols, porcentaje = FALSE, estandar = TRUE)
}
\arguments{
\item{data_event}{Un `data.frame` que contiene los datos de
una enfermedad o evento.}

\item{nomb_cols}{Un `character` (cadena de caracteres) o
`array (arreglo) de character` que contiene el nombre de
la(s) columna(s) en los datos de la enfermedad o evento.}

\item{porcentaje}{Un `logical` (TRUE o FALSE) que indica
si se debe agregar una columna con el porcentaje de casos;
su valor por defecto es `FALSE`.}

\item{estandar}{Un `logical` (TRUE o FALSE) que indica
si se debe utilizar el estándar de agrupación de los datos
del evento o enfermedad propuesto por el paquete, es decir,
que se incluyan estas columnas o variables como parte del
resultado `c("cod_eve", "nombre_evento", "ano")`; su valor
por defecto es `TRUE`, si su valor es `FALSE` agrupará los
datos solamente por las columnas o variables enviadas en el
parámetro `nomb_cols`.}
}
\value{
Un `data.frame` con los datos de una enfermedad
o evento agrupados por el nombre de la(s) columna(s) y el
número de casos.
}
\description{
Función que agrupa los datos de una enfermedad o evento
por nombre de columna(s) y número de casos.
}
\examples{
data(dengue2020)
data_limpia <- limpiar_data_sivigila(data_event = dengue2020)
agrupar_cols_casos(
  data_event = data_limpia,
  nomb_cols = "sexo",
  porcentaje = TRUE
)
agrupar_cols_casos(
  data_event = data_limpia,
  nomb_cols = c("sexo", "semana")
)
}
