% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{skipTrack.visualize}
\alias{skipTrack.visualize}
\title{Visualize Results from skipTrack.fit}
\usage{
skipTrack.visualize(stFit)
}
\arguments{
\item{stFit}{A list containing MCMC results obtained from skipTrack.fit.}
}
\value{
A list of three ggplot2 objects:
\itemize{
\item cijOverLength - Scatter plot of estimated Cij values against reported cycle length.
\item cijOverTaus - Scatter plot of estimated Cij values against estimated individual precisions, colored by cycle length.
\item cijDens - Density plot of Y values overlayed with a density plot of Y values separated by estimated cij value.
}
}
\description{
This function takes results from skipTrack.fit and produces several helpful visualizations.
}
\examples{
#Simulated data
simDat <- skipTrack.simulate(n = 100, skipProb = c(.7, .2, .1))

#Run model fit (should typically run with much more than 50 reps)
modFit <- skipTrack.fit(Y = simDat$Y, cluster = simDat$cluster, chains = 2, reps = 50)

#Visualize results
skipTrack.visualize(modFit)

}
\seealso{
\code{\link{skipTrack.fit}} for generating MCMC results.
}
