% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/events.R
\name{zenith}
\alias{zenith}
\title{Declination of the zenith sun for a given location}
\usage{
zenith(loc, parallax = 0.00224, altitude = 0)
}
\arguments{
\item{loc}{This can be either the latitude of the
location, or a \emph{skyscapeR.horizon} object.}

\item{parallax}{(Optional) Average parallax value for the sun.
Defaults to 0.00224.}

\item{altitude}{(Optional) Altitude of the sun. Defaults to 0 degrees.}
}
\description{
This function returns the declination of the sun
when it is at the zenith for a given location with
corrected average parallax. If this phenomena does
not occur at given location (i.e. if location is
outside the tropical band) the function returns a
\emph{NULL} value.
}
\examples{
# Zenith sun declination for Mexico City:
zenith(19.419)

# There is no zenith sun phenomenon in London:
zenith(51.507)
}
\seealso{
\code{\link{jS}}, \code{\link{dS}}, \code{\link{eq}},
\code{\link{antizenith}}, \code{\link{spatial.equinox}}, \code{\link{parallax.corr}}
}
