% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods.R
\name{pls}
\alias{pls}
\alias{pls.smooth}
\title{Prediction Likelihood Score}
\usage{
pls(object, holdout = NULL, ...)

\method{pls}{smooth}(object, holdout = NULL, ...)
}
\arguments{
\item{object}{The model estimated using smooth functions. This thing also accepts
other models (e.g. estimated using functions from forecast package), but may not always
work properly with them.}

\item{holdout}{The values for the holdout part of the sample. If the model was fitted
on the data with the \code{holdout=TRUE}, then the parameter is not needed.}

\item{...}{Parameters passed to multicov function. The function is called in order to get
the covariance matrix of 1 to h steps ahead forecast errors.}
}
\value{
A value of the log-likelihood.
}
\description{
Function estimates Prediction Likelihood Score for the provided model
}
\details{
Prediction likelihood score (PLS) is based on either normal or log-normal
distribution of errors. This is extracted from the provided model. The likelihood
based on the distribution of 1 to h steps ahead forecast errors is used in the process.
}
\examples{

# Generate data, apply es() with the holdout parameter and calculate PLS
x <- rnorm(100,0,1)
ourModel <- es(x, h=10, holdout=TRUE)
pls(ourModel, type="a")
pls(ourModel, type="e")
pls(ourModel, type="s", obs=100, nsim=100)

}
\references{
\itemize{
%\item Eltoft, T., Taesu, K., Te-Won, L. (2006). On the multivariate Laplace
distribution. IEEE Signal Processing Letters. 13 (5): 300-303.
\doi{10.1109/LSP.2006.870353} - this is not yet used in the function.
\item Snyder, R. D., Ord, J. K., Beaumont, A., 2012. Forecasting the intermittent
demand for slow-moving inventories: A modelling approach. International
Journal of Forecasting 28 (2), 485-496.
\item Kolassa, S., 2016. Evaluating predictive count data distributions in retail
sales forecasting. International Journal of Forecasting 32 (3), 788-803..
}
}
\author{
Ivan Svetunkov, \email{ivan@svetunkov.com}
}
\keyword{models}
\keyword{nonlinear}
\keyword{regression}
\keyword{smooth}
\keyword{ts}
\keyword{univar}
