% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readMatrix.R
\name{readMatrix}
\alias{readMatrix}
\title{Read a CSV File and Convert to a Matrix}
\usage{
readMatrix(file_path, remove_row_headings = FALSE, scaling = "no")
}
\arguments{
\item{file_path}{A string specifying the path to the CSV file.}

\item{remove_row_headings}{A logical value. If `TRUE`, removes the first column of the dataset. This is useful when the first column contains non-numeric identifiers (e.g., sample names) that should be excluded from the analysis. Default is `FALSE`.}

\item{scaling}{A string specifying the scaling method. Options are:
\describe{
  \item{"no"}{No scaling is applied (default).}
  \item{"SimpleFeature"}{Each column is divided by its maximum value.}
  \item{"MinMax"}{Each column is scaled to range [0, 1].}
  \item{"ZScore"}{Each column is Z-score standardized.}
}}
}
\value{
A matrix with the processed data.
}
\description{
Reads data from a CSV file, optionally removes row headings, and applies
specified normalization methods before converting the data to a matrix. In
the original dataset, rows represent observations (e.g., samples), columns
represent variables (e.g., features), and all cells (except for column
headers and, in case, row headers) only contain numeric values.
}
\examples{
# Load the toy data from the package's inst/extdata/ directory
file_path <- system.file("extdata", "toy_data.csv", package = "somhca")

# Run the readMatrix function with the mock data
myMatrix <- readMatrix(file_path, TRUE, "MinMax")
}
