/*
 * Decompiled with CFR 0.152.
 */
package sparklyr;

import java.io.ByteArrayOutputStream;
import java.io.Serializable;
import org.apache.spark.TaskContext;
import org.apache.spark.TaskContext$;
import org.apache.spark.api.java.JavaRDD;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Encoder;
import org.apache.spark.sql.Encoders$;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.CatalystTypeConverters$;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.types.DataType;
import org.apache.spark.sql.types.StructType;
import scala.Array$;
import scala.Function1;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.collection.Iterator;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import sparklyr.ArrowBatchStreamWriter;
import sparklyr.ArrowConvertersImpl;
import sparklyr.ArrowRowIterator;
import sparklyr.Invoke;
import sparklyr.Logger;

public final class ArrowConverters$ {
    public static ArrowConverters$ MODULE$;

    static {
        new ArrowConverters$();
    }

    public Iterator<Row> fromPayloadArray(byte[][] records, StructType schema) {
        TaskContext context = TaskContext$.MODULE$.get();
        Iterator singleRecords = new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])records)).map((Function1 & Serializable & scala.Serializable)record -> record, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(ScalaRunTime$.MODULE$.arrayClass(Byte.TYPE)))))).iterator();
        ArrowRowIterator iter = new ArrowConvertersImpl().fromPayloadIterator((Iterator<byte[]>)singleRecords, (Option<TaskContext>)Option$.MODULE$.empty());
        Function1 converter = CatalystTypeConverters$.MODULE$.createToScalaConverter((DataType)schema);
        return iter.map((Function1 & Serializable & scala.Serializable)x$1 -> (Row)converter.apply(x$1));
    }

    public Dataset<byte[]> toArrowDataset(Dataset<Row> df, SparkSession sparkSession, String timeZoneId) {
        StructType schema = df.schema();
        int maxRecordsPerBatch = sparkSession.sessionState().conf().arrowMaxRecordsPerBatch();
        Encoder encoder = Encoders$.MODULE$.BINARY();
        return df.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> new ArrowConvertersImpl().toBatchIterator((Iterator<Row>)iter, schema, maxRecordsPerBatch, timeZoneId, TaskContext$.MODULE$.get()), encoder);
    }

    public byte[] toArrowStream(Dataset<Row> df, String timeZoneId, Iterator<byte[]> batchIter) {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrowBatchStreamWriter batchWriter = new ArrowBatchStreamWriter(df.schema(), out, timeZoneId);
        batchWriter.writeOneBatch(batchIter);
        batchWriter.end();
        return out.toByteArray();
    }

    public byte[] toArrowBatchRdd(Dataset<Row> df, SparkSession sparkSession, String timeZoneId) {
        byte[][] batches = (byte[][])this.toArrowDataset(df, sparkSession, timeZoneId).collect();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        ArrowBatchStreamWriter batchWriter = new ArrowBatchStreamWriter(df.schema(), out, timeZoneId);
        batchWriter.writeBatches((Iterator<byte[]>)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])batches)).iterator());
        batchWriter.end();
        return out.toByteArray();
    }

    public Dataset<Row> toDataFrame(JavaRDD<byte[]> payloadRDD, StructType schema, SparkSession sparkSession) {
        return this.toDataFrame((RDD<byte[]>)payloadRDD.rdd(), schema, sparkSession);
    }

    public Dataset<Row> toDataFrame(RDD<byte[]> payloadRDD, StructType schema, SparkSession sparkSession) {
        RDD rdd = payloadRDD.mapPartitions((Function1 & Serializable & scala.Serializable)iter -> {
            ArrowConvertersImpl converters = new ArrowConvertersImpl();
            TaskContext context = TaskContext$.MODULE$.get();
            return converters.fromPayloadIterator((Iterator<byte[]>)iter, context);
        }, payloadRDD.mapPartitions$default$2(), ClassTag$.MODULE$.apply(InternalRow.class));
        Logger logger = new Logger("Arrow", 0);
        Invoke invoke = new Invoke();
        boolean streaming = false;
        return (Dataset)invoke.invoke(sparkSession.sqlContext().getClass(), "", sparkSession.sqlContext(), "internalCreateDataFrame", new Object[]{rdd, schema, BoxesRunTime.boxToBoolean((boolean)streaming)}, logger);
    }

    private ArrowConverters$() {
        MODULE$ = this;
    }
}

