% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{get_gene_meta}
\alias{get_gene_meta}
\title{get_gene_meta: Extract gene-level metadata and statistics}
\usage{
get_gene_meta(x = NULL, sthet_only = FALSE)
}
\arguments{
\item{x}{an STlist}

\item{sthet_only}{logical, return only genes with spatial statistics}
}
\value{
a data frame with gene-level data
}
\description{
Extracts gene-level metadata and spatial statistics (if already computed)
}
\details{
This function extracts data from the \code{x@gene_meta} slot, optionally subsetting
only to those genes for which spatial statistics (Moran's I or Geary's C, see \code{SThet})
have been calculated. The output is a data frame with data from all samples in the
STlist
}
\examples{
\donttest{
# Using included melanoma example (Thrane et al.)
# Download example data set from spatialGE_Data
thrane_tmp = tempdir()
unlink(thrane_tmp, recursive=TRUE)
dir.create(thrane_tmp)
lk='https://github.com/FridleyLab/spatialGE_Data/raw/refs/heads/main/melanoma_thrane.zip?download='
tryCatch({ # In case data is not available from network
  download.file(lk, destfile=paste0(thrane_tmp, '/', 'melanoma_thrane.zip'), mode='wb')
  #' zip_tmp = list.files(thrane_tmp, pattern='melanoma_thrane.zip$', full.names=TRUE)
  unzip(zipfile=zip_tmp, exdir=thrane_tmp)
  # Generate the file paths to be passed to the STlist function
  count_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                            full.names=TRUE, pattern='counts')
  coord_files <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                            full.names=TRUE, pattern='mapping')
  clin_file <- list.files(paste0(thrane_tmp, '/melanoma_thrane'),
                          full.names=TRUE, pattern='clinical')
  # Create STlist
  library('spatialGE')
  melanoma <- STlist(rnacounts=count_files,
                     spotcoords=coord_files,
                     samples=clin_file)
  melanoma <- transform_data(melanoma)
  melanoma <- SThet(melanoma, genes=c('MLANA', 'TP53'), method='moran')
  get_gene_meta(melanoma, sthet_only=TRUE)
}, error = function(e) {
  message("Could not run example. Are you connected to the internet?")
  return(NULL)
})
}

}
