% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinetic_ising_ensemble.R
\name{kinetic_ising_exemplar}
\alias{kinetic_ising_exemplar}
\title{Exemplar of an Ising model for spatial data}
\usage{
kinetic_ising_exemplar(runs, ...)
}
\arguments{
\item{runs}{A number of simulations to perform}

\item{...}{Arguments for \code{\link[=kinetic_ising]{kinetic_ising()}}}
}
\value{
Object of the same class as \code{x}
}
\description{
Creates an ensemble of simulations based on the given parameters
of the Ising model and selects an exemplar
(a model that is closest to the average of the ensemble)
}
\examples{
data(r_start, package = "spatialising")
l = kinetic_ising_exemplar(100, r_start, B = -0.3, J = 0.7)

\donttest{
  library(terra)
  r1 = rast(system.file("raster/r_start.tif", package = "spatialising"))
  plot(r1)
  r2 = kinetic_ising_exemplar(100, r1, B = -0.3, J = 0.7)
  plot(r2)
}
}
\seealso{
\code{\link[=kinetic_ising]{kinetic_ising()}}, \code{\link[=kinetic_ising_ensemble]{kinetic_ising_ensemble()}}
}
