% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/constrLaplacianRank.R
\name{learn_smooth_approx_graph}
\alias{learn_smooth_approx_graph}
\title{Learns a smooth approximated graph from an observed data matrix.
Check out https://mirca.github.io/spectralGraphTopology for code examples.}
\usage{
learn_smooth_approx_graph(Y, m)
}
\arguments{
\item{Y}{a p-by-n data matrix, where p is the number of nodes and n is the number of
features (or data points per node)}

\item{m}{the maximum number of possible connections for a given node used
to build an affinity matrix}
}
\value{
A list containing the following elements:
\item{\code{laplacian}}{the estimated Laplacian Matrix}
}
\description{
Learns a smooth approximated graph from an observed data matrix.
Check out https://mirca.github.io/spectralGraphTopology for code examples.
}
\references{
Nie, Feiping and Wang, Xiaoqian and Jordan, Michael I. and Huang, Heng.
            The Constrained Laplacian Rank Algorithm for Graph-based Clustering, 2016,
            AAAI'16. http://dl.acm.org/citation.cfm?id=3016100.3016174
}
\author{
Ze Vinicius and Daniel Palomar
}
