% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_alt.R
\name{rot_ab}
\alias{rot_ab}
\alias{H_ab}
\title{Rotate a sample of spherical data}
\usage{
rot_ab(X, a, b)

H_ab(a, b)
}
\arguments{
\item{X}{a sample of spherical data, an array of size \code{c(n, p, M)} or
a matrix of size \code{c(n, p)}.}

\item{a}{vector on \eqn{S^{p-1}} to rotate from.}

\item{b}{vector on \eqn{S^{p-1}} to rotate to.}
}
\value{
\itemize{
  \item \code{rot_ab}: an array or matrix with the same size as \code{X}
  containing the rotated sample.
  \item \code{H_ab}: a rotation matrix of size \code{c(p, p)}.
}
}
\description{
Rotate a sample of spherical data by a rotation matrix
\eqn{{\bf H}_{{\bf a},{\bf b}} = ({\bf a}+{\bf b})({\bf a}+{\bf b})' /
(1 + {\bf a}'{\bf b}) - {\bf I}_p}.
}
\details{
The vectors \code{a} and \code{b} are checked for unit norms.
}
\examples{
p <- 3
a <- c(rep(0, p - 1), 1)
b <- c(1, rep(0, p - 1))
H_ab(a = a, b = b)
X <- r_alt(n = 100, p = p, M = 1, alt = "vMF", kappa = 10)[, , 1]
X_rot <- rot_ab(X, a = a, b = b)
s3d <- scatterplot3d::scatterplot3d(X, pch = 16, xlim = c(-1.1, 1.1),
                             ylim = c(-1.1, 1.1), zlim = c(-1.1, 1.1))
s3d$points3d(X_rot, col = 2, pch = 16)
}
