% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/read.GB.R
\name{read.GB}
\alias{read.GB}
\title{Download sequences from Genbank with metadata.}
\usage{
read.GB(access.nb, seq.names = access.nb, species.names = TRUE,
  gene = TRUE, access = TRUE, as.character = FALSE)
}
\arguments{
\item{access.nb}{A character vector giving the GenBank accession numbers to
download.}

\item{seq.names}{A character vector giving the names to give to each
sequence. Defaults to "accession number | species name".}

\item{species.names}{Logical. Should species names be downloaded? Default of
TRUE.}

\item{gene}{Logical. Should the name of the gene region be downloaded?
Default of TRUE.}

\item{access}{Logical. Should the accession number be downloaded? Default of
TRUE.}

\item{as.character}{Logical. Should the sequences be returned as character
vector? Default of FALSE, function returns sequences as a `DNAbin' object.}
}
\value{
A 'DNAbin' object with the following attributes: \code{"species"},
\code{"gene"}, and \code{"accession_num"}.
}
\description{
Downloads sequences associated with the given accession numbers into a
`DNAbin' class.
}
\details{
This function is a modification of
\code{\link[ape:ape-package]{read.GenBank}} to include metadata with each
sequence. Additional data currently implemented are the species names and
the gene region from which sequences were derived.
}
\section{Warning}{
 15 Feb 2018: 'read.GB' is deprecated. Please use the rOpenSci packages 'rentrez' and 'traits', or 'ape' for better functionality.
}

\examples{

\dontrun{
read.GB("AY059961")

#Download the sequences making data(anoteropsis) from Genbank
nums <- 59961:59993
seqs <- paste("AY0", nums, sep="")
dat <- read.GB(seqs)

attr(dat, "species")
attr(dat, "gene")
attr(dat, "accession_num")}

}
\seealso{
\code{\link{read.GenBank}}.
}
\author{
Samuel Brown <s_d_j_brown@hotmail.com>
}
\keyword{Datasets}
