% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/index_mean.R
\name{ppi_mean}
\alias{ppi_mean}
\title{Simulate and Summarize Projection Pursuit Index (PPI) Values}
\usage{
ppi_mean(data, index_fun, n_sim = 100, n_obs = 300)
}
\arguments{
\item{data}{A data frame or matrix. Must have at least two columns.}

\item{index_fun}{A function taking two numeric vectors (\code{x}, \code{y}) and returning a scalar index.}

\item{n_sim}{Integer. Number of simulations. Default is 100.}

\item{n_obs}{Integer. Number of observations to sample in each simulation. Default is 300.}
}
\value{
A tibble with:
\itemize{
\item \code{var_i}, \code{var_j}: Names of variable pairs
\item \code{mean_index}: Mean index value over simulations
}
}
\description{
Simulate and Summarize Projection Pursuit Index (PPI) Values
}
\examples{
data <- as.data.frame(data_gen(type = "polynomial", degree = 2))
ppi_mean(data, scag_index("stringy"), n_sim = 10)
}
