% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/features-volleyball.R
\name{volleyball_backcourt}
\alias{volleyball_backcourt}
\title{The backcourt is the area between the the attack line (see
\code{\link[=volleyball_attack_line]{volleyball_attack_line()}}) and the end line (see \code{\link[=volleyball_end_line]{volleyball_end_line()}}).
Players playing in the back row of the rotation must take off from this area
before attacking the ball. If considering the entirety of the volleyball
court as being divided into thirds, this is \emph{either} of the outer thirds of
the court}
\usage{
volleyball_backcourt(
  attack_line_edge_to_center_line = 0,
  court_length = 0,
  court_width = 0
)
}
\arguments{
\item{attack_line_edge_to_center_line}{The distance from the edge furthest
from the attack line to the center of the line running along \code{x = 0}}

\item{court_length}{The length of the court, measured from the exterior edges
of the end lines}

\item{court_width}{The width of the court, measured from the exterior edges
of the sidelines}
}
\value{
A data frame containing the bounding coordinates of the backcourt
}
\description{
The backcourt is the area between the the attack line (see
\code{\link[=volleyball_attack_line]{volleyball_attack_line()}}) and the end line (see \code{\link[=volleyball_end_line]{volleyball_end_line()}}).
Players playing in the back row of the rotation must take off from this area
before attacking the ball. If considering the entirety of the volleyball
court as being divided into thirds, this is \emph{either} of the outer thirds of
the court
}
\keyword{internal}
