% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/predict.R
\name{predict.fitdists}
\alias{predict.fitdists}
\title{Predict Hazard Concentrations of fitdists Object}
\usage{
\method{predict}{fitdists}(
  object,
  percent,
  proportion = 1:99/100,
  average = TRUE,
  ci = FALSE,
  level = 0.95,
  nboot = 1000,
  min_pboot = 0.95,
  multi_est = TRUE,
  ci_method = "weighted_samples",
  parametric = TRUE,
  delta = 9.21,
  control = NULL,
  ...
)
}
\arguments{
\item{object}{The object.}

\item{percent}{A numeric vector of percent values to estimate hazard concentrations for. Soft-deprecated for \code{proportion = 0.05}.}

\item{proportion}{A numeric vector of proportion values to estimate hazard concentrations for.}

\item{average}{A flag specifying whether to provide model averaged values as opposed to a value for each distribution.}

\item{ci}{A flag specifying whether to estimate confidence intervals (by bootstrapping).}

\item{level}{A number between 0 and 1 of the confidence level of the interval.}

\item{nboot}{A count of the number of bootstrap samples to use to estimate the confidence limits. A value of 10,000 is recommended for official guidelines.}

\item{min_pboot}{A number between 0 and 1 of the minimum
proportion of bootstrap samples that must successfully fit (return a likelihood)
to report the confidence intervals.}

\item{multi_est}{A flag specifying whether to treat the distributions as constituting a single distribution (as opposed to taking the mean) when calculating model averaged estimates.}

\item{ci_method}{A string specifying which method to use for estimating the bootstrap values.
Possible values are "multi_free" and "multi_fixed" which treat the distributions as constituting a single distribution but differ in whether the model weights are fixed and "weighted_samples" and "weighted_arithmetic" take bootstrap samples from each distribution proportional to its weight versus calculating the weighted arithmetic means of the lower and upper confidence limits.}

\item{parametric}{A flag specifying whether to perform parametric bootstrapping as opposed to non-parametrically resampling the original data with replacement.}

\item{delta}{A non-negative number specifying the maximum absolute AIC difference cutoff.
Distributions with an absolute AIC difference greater than delta are excluded from the calculations.}

\item{control}{A list of control parameters passed to \code{\link[stats:optim]{stats::optim()}}.}

\item{...}{Unused.}
}
\description{
A wrapper on \code{\link[=ssd_hc]{ssd_hc()}} that by default calculates
all hazard concentrations from 1 to 99\%.
}
\details{
It is useful for plotting purposes.
}
\examples{
fits <- ssd_fit_dists(ssddata::ccme_boron)
predict(fits)
}
\seealso{
\code{\link[=ssd_hc]{ssd_hc()}} and \code{\link[=ssd_plot]{ssd_plot()}}
}
