% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/burrrIII3.R, R/gamma.R, R/gompertz.R,
%   R/invpareto.R, R/lgumbel.R, R/llogis-llogis.R, R/llogis.R, R/lnorm-lnorm.R,
%   R/lnorm.R, R/multi.R, R/pqr.R, R/weibull.R
\name{ssd_rburrIII3}
\alias{ssd_rburrIII3}
\alias{ssd_rgamma}
\alias{ssd_rgompertz}
\alias{ssd_rinvpareto}
\alias{ssd_rlgumbel}
\alias{ssd_rllogis_llogis}
\alias{ssd_rllogis}
\alias{ssd_rlnorm_lnorm}
\alias{ssd_rlnorm}
\alias{ssd_rmulti}
\alias{ssd_rmulti_fitdists}
\alias{ssd_r}
\alias{ssd_rweibull}
\title{Random Number Generation}
\usage{
ssd_rburrIII3(n, shape1 = 1, shape2 = 1, scale = 1, chk = TRUE)

ssd_rgamma(n, shape = 1, scale = 1, chk = TRUE)

ssd_rgompertz(n, location = 1, shape = 1, chk = TRUE)

ssd_rinvpareto(n, shape = 3, scale = 1, chk = TRUE)

ssd_rlgumbel(n, locationlog = 0, scalelog = 1, chk = TRUE)

ssd_rllogis_llogis(
  n,
  locationlog1 = 0,
  scalelog1 = 1,
  locationlog2 = 1,
  scalelog2 = 1,
  pmix = 0.5,
  chk = TRUE
)

ssd_rllogis(n, locationlog = 0, scalelog = 1, chk = TRUE)

ssd_rlnorm_lnorm(
  n,
  meanlog1 = 0,
  sdlog1 = 1,
  meanlog2 = 1,
  sdlog2 = 1,
  pmix = 0.5,
  chk = TRUE
)

ssd_rlnorm(n, meanlog = 0, sdlog = 1, chk = TRUE)

ssd_rmulti(
  n,
  burrIII3.weight = 0,
  burrIII3.shape1 = 1,
  burrIII3.shape2 = 1,
  burrIII3.scale = 1,
  gamma.weight = 0,
  gamma.shape = 1,
  gamma.scale = 1,
  gompertz.weight = 0,
  gompertz.location = 1,
  gompertz.shape = 1,
  invpareto.weight = 0,
  invpareto.shape = 3,
  invpareto.scale = 1,
  lgumbel.weight = 0,
  lgumbel.locationlog = 0,
  lgumbel.scalelog = 1,
  llogis.weight = 0,
  llogis.locationlog = 0,
  llogis.scalelog = 1,
  llogis_llogis.weight = 0,
  llogis_llogis.locationlog1 = 0,
  llogis_llogis.scalelog1 = 1,
  llogis_llogis.locationlog2 = 1,
  llogis_llogis.scalelog2 = 1,
  llogis_llogis.pmix = 0.5,
  lnorm.weight = 0,
  lnorm.meanlog = 0,
  lnorm.sdlog = 1,
  lnorm_lnorm.weight = 0,
  lnorm_lnorm.meanlog1 = 0,
  lnorm_lnorm.sdlog1 = 1,
  lnorm_lnorm.meanlog2 = 1,
  lnorm_lnorm.sdlog2 = 1,
  lnorm_lnorm.pmix = 0.5,
  weibull.weight = 0,
  weibull.shape = 1,
  weibull.scale = 1,
  chk = TRUE
)

ssd_rmulti_fitdists(n, fitdists, chk = TRUE)

ssd_rweibull(n, shape = 1, scale = 1, chk = TRUE)
}
\arguments{
\item{n}{positive number of observations.}

\item{shape1}{shape1 parameter.}

\item{shape2}{shape2 parameter.}

\item{scale}{scale parameter.}

\item{chk}{A flag specifying whether to check the arguments.}

\item{shape}{shape parameter.}

\item{location}{location parameter.}

\item{locationlog}{location on the log scale parameter.}

\item{scalelog}{scale on log scale parameter.}

\item{locationlog1}{locationlog1 parameter.}

\item{scalelog1}{scalelog1 parameter.}

\item{locationlog2}{locationlog2 parameter.}

\item{scalelog2}{scalelog2 parameter.}

\item{pmix}{Proportion mixture parameter.}

\item{meanlog1}{mean on log scale parameter.}

\item{sdlog1}{standard deviation on log scale parameter.}

\item{meanlog2}{mean on log scale parameter.}

\item{sdlog2}{standard deviation on log scale parameter.}

\item{meanlog}{mean on log scale parameter.}

\item{sdlog}{standard deviation on log scale parameter.}

\item{burrIII3.weight}{weight parameter for the Burr III distribution.}

\item{burrIII3.shape1}{shape1 parameter for the Burr III distribution.}

\item{burrIII3.shape2}{shape2 parameter for the Burr III distribution.}

\item{burrIII3.scale}{scale parameter for the Burr III distribution.}

\item{gamma.weight}{weight parameter for the gamma distribution.}

\item{gamma.shape}{shape parameter for the gamma distribution.}

\item{gamma.scale}{scale parameter for the gamma distribution.}

\item{gompertz.weight}{weight parameter for the Gompertz distribution.}

\item{gompertz.location}{location parameter for the Gompertz distribution.}

\item{gompertz.shape}{shape parameter for the Gompertz distribution.}

\item{invpareto.weight}{weight parameter for the inverse Pareto distribution.}

\item{invpareto.shape}{shape parameter for the inverse Pareto distribution.}

\item{invpareto.scale}{scale parameter for the inverse Pareto distribution.}

\item{lgumbel.weight}{weight parameter for the log-Gumbel distribution.}

\item{lgumbel.locationlog}{location parameter for the log-Gumbel distribution.}

\item{lgumbel.scalelog}{scale parameter for the log-Gumbel distribution.}

\item{llogis.weight}{weight parameter for the log-logistic distribution.}

\item{llogis.locationlog}{location parameter for the log-logistic distribution.}

\item{llogis.scalelog}{scale parameter for the log-logistic distribution.}

\item{llogis_llogis.weight}{weight parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.locationlog1}{locationlog1 parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.scalelog1}{scalelog1 parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.locationlog2}{locationlog2 parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.scalelog2}{scalelog2 parameter for the log-logistic log-logistic mixture distribution.}

\item{llogis_llogis.pmix}{pmix parameter for the log-logistic log-logistic mixture distribution.}

\item{lnorm.weight}{weight parameter for the log-normal distribution.}

\item{lnorm.meanlog}{meanlog parameter for the log-normal distribution.}

\item{lnorm.sdlog}{sdlog parameter for the log-normal distribution.}

\item{lnorm_lnorm.weight}{weight parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.meanlog1}{meanlog1 parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.sdlog1}{sdlog1 parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.meanlog2}{meanlog2 parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.sdlog2}{sdlog2 parameter for the log-normal log-normal mixture distribution.}

\item{lnorm_lnorm.pmix}{pmix parameter for the log-normal log-normal mixture distribution.}

\item{weibull.weight}{weight parameter for the Weibull distribution.}

\item{weibull.shape}{shape parameter for the Weibull distribution.}

\item{weibull.scale}{scale parameter for the Weibull distribution.}

\item{fitdists}{An object of class fitdists.}
}
\description{
Random Number Generation
}
\section{Functions}{
\itemize{
\item \code{ssd_rburrIII3()}: Random Generation for BurrIII Distribution

\item \code{ssd_rgamma()}: Random Generation for Gamma Distribution

\item \code{ssd_rgompertz()}: Random Generation for Gompertz Distribution

\item \code{ssd_rinvpareto()}: Random Generation for Inverse Pareto Distribution

\item \code{ssd_rlgumbel()}: Random Generation for log-Gumbel Distribution

\item \code{ssd_rllogis_llogis()}: Random Generation for Log-Logistic/Log-Logistic Mixture Distribution

\item \code{ssd_rllogis()}: Random Generation for Log-Logistic Distribution

\item \code{ssd_rlnorm_lnorm()}: Random Generation for Log-Normal/Log-Normal Mixture Distribution

\item \code{ssd_rlnorm()}: Random Generation for Log-Normal Distribution

\item \code{ssd_rmulti()}: Random Generation for Multiple Distributions

\item \code{ssd_rmulti_fitdists()}: Random Generation for Multiple Distributions

\item \code{ssd_rweibull()}: Random Generation for Weibull Distribution

}}
\examples{

set.seed(50)
hist(ssd_rburrIII3(10000), breaks = 1000)

set.seed(50)
hist(ssd_rgamma(10000), breaks = 1000)

set.seed(50)
hist(ssd_rgompertz(10000), breaks = 1000)

set.seed(50)
hist(ssd_rinvpareto(10000), breaks = 1000)

set.seed(50)
hist(ssd_rlgumbel(10000), breaks = 1000)

set.seed(50)
hist(ssd_rllogis_llogis(10000), breaks = 1000)

set.seed(50)
hist(ssd_rllogis(10000), breaks = 1000)

set.seed(50)
hist(ssd_rlnorm_lnorm(10000), breaks = 1000)

set.seed(50)
hist(ssd_rlnorm(10000), breaks = 1000)

# multi
set.seed(50)
hist(ssd_rmulti(1000, gamma.weight = 0.5, lnorm.weight = 0.5), breaks = 100)

# multi fitdists
fit <- ssd_fit_dists(ssddata::ccme_boron)
ssd_rmulti_fitdists(2, fit)

set.seed(50)
hist(ssd_rweibull(10000), breaks = 1000)
}
\seealso{
\code{\link{ssd_p}} and \code{\link{ssd_q}}
}
