% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stars.R
\name{st_dim_to_attr}
\alias{st_dim_to_attr}
\title{create an array with dimension values}
\usage{
st_dim_to_attr(x, which = seq_along(dim(x)))
}
\arguments{
\item{x}{object of class \code{stars}}

\item{which}{integer; indices of the dimensions to address (default: all)}
}
\value{
\code{stars} object with dimension values as attributes
}
\description{
create an array with dimension values
}
\examples{
tif = system.file("tif/L7_ETMs.tif", package = "stars")
x1 = read_stars(tif)
(x = st_dim_to_attr(x1))
plot(x)
(x = st_dim_to_attr(x1, 2:3))
plot(x)
(x= st_dim_to_attr(x1, 3))
plot(x)
}
