/*
 * Decompiled with CFR 0.152.
 */
package haplotype;

import beagleutil.Samples;
import haplotype.HapPairs;
import vcf.Marker;
import vcf.Markers;

public final class RevHapPairs
implements HapPairs {
    private final HapPairs hapPairs;
    private final int lastMarker;

    public RevHapPairs(HapPairs hapPairs) {
        this.hapPairs = hapPairs;
        this.lastMarker = hapPairs.nMarkers() - 1;
    }

    @Override
    public int allele1(int n, int n2) {
        return this.hapPairs.allele1(this.lastMarker - n, n2);
    }

    @Override
    public int allele2(int n, int n2) {
        return this.hapPairs.allele2(this.lastMarker - n, n2);
    }

    @Override
    public int allele(int n, int n2) {
        return this.hapPairs.allele(this.lastMarker - n, n2);
    }

    @Override
    public int nMarkers() {
        return this.hapPairs.nMarkers();
    }

    @Override
    public Markers markers() {
        return this.hapPairs.markers().reverse();
    }

    @Override
    public Marker marker(int n) {
        return this.hapPairs.marker(this.lastMarker - n);
    }

    @Override
    public int nHaps() {
        return this.hapPairs.nHaps();
    }

    @Override
    public int nHapPairs() {
        return this.hapPairs.nHapPairs();
    }

    @Override
    public Samples samples(int n) {
        return this.hapPairs.samples(n);
    }

    @Override
    public int sampleIndex(int n) {
        return this.hapPairs.sampleIndex(n);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(10000);
        stringBuilder.append('[');
        stringBuilder.append(this.getClass().toString());
        stringBuilder.append(": nHapPairs=");
        stringBuilder.append(this.nHapPairs());
        stringBuilder.append(']');
        return stringBuilder.toString();
    }
}

