% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stlkinhom.R
\name{STLKinhom}
\alias{STLKinhom}
\title{Inhomogeneous K-function for spatio-temporal  point processes on linear networks}
\usage{
STLKinhom(X,lambda=lambda,normalize=FALSE,r=NULL,t=NULL,nxy=10)
}
\arguments{
\item{X}{a spatio-temporal point pattern of class \code{\link{stlpp}}}

\item{lambda}{values of estimated intensity at data points}

\item{normalize}{normalization factor to be considered}

\item{r}{values of argument r where pair correlation function will be evaluated. optional}

\item{t}{values of argument t where pair correlation function will be evaluated. optional}

\item{nxy}{pixel array dimensions. optional}
}
\value{
An object of class \code{sumstlpp}.
}
\description{
This function computes the inhomogeneous K-function for spatio-temporal  point patterns on linear networks.
}
\details{
This function calculates the inhomogeneous K-function for a spatio-temporal point patterns on a linear network.
}
\examples{
X <- rpoistlpp(.2,a=0,b=5,L=easynet)
lambda <- density(X,at="points")
k <- STLKinhom(X,lambda=lambda,normalize=TRUE)
plot(k)


}
\references{
Moradi, M., & Mateu, J. (2020). First-and second-order characteristics of spatio-temporal point processes on linear networks. Journal of Computational and Graphical Statistics, 29(3), 432-443.
}
\seealso{
\code{\link{STLg}}, \code{\link{STLK}}, \code{\link{STLginhom}}
}
\author{
Mehdi Moradi <m2.moradi@yahoo.com>
}
