% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratEst_strategy.R
\name{stratEst.strategy}
\alias{stratEst.strategy}
\title{Creates a stratEst.strategy object.}
\usage{
stratEst.strategy(
  choices,
  inputs = NULL,
  prob.choices = NULL,
  tr.inputs = NULL,
  trembles = NULL,
  num.states = NULL
)
}
\arguments{
\item{choices}{a character vector. The levels of the factor \code{choice} in the data.}

\item{inputs}{a character vector. The levels of the factor \code{input} in the data.}

\item{prob.choices}{a numeric vector. The choice probabilities of the strategy in columnwise order.}

\item{tr.inputs}{a vector of integers. The deterministic state transitions of the strategy in columnwise order.}

\item{trembles}{a numeric vector. The tremble probabilities of the strategy.}

\item{num.states}{an integer. The number states of the strategy.}
}
\value{
A \code{stratEst.strategy} object. A data.frame with the following variables:
\item{prob.x}{the probability of choice \code{x}.}
\item{tremble}{the probability to observe a tremble.}
\item{tr(x)}{the deterministic state transitions of the strategy for input \code{x}.}
}
\description{
Creates a stratEst.strategy object.
}
\details{
The strategy generation function of the package.
}
\examples{
## Nash equilibrium strategy of rock-paper-scissors
ins = c(NA,"rock","paper","scissors")
rps = c("rock","paper","scissors")
mixed = stratEst.strategy(choices = rps)
nash = stratEst.strategy(choices = rps, prob.choices = rep(1/3,3))
rock = stratEst.strategy(choices = rps, prob.choices = c(1,0,0))
}
