% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tb.R
\name{tb}
\alias{tb}
\title{Convert Summarytools Objects into Tibbles}
\usage{
tb(
  x,
  order = 1,
  drop.var.col = FALSE,
  recalculate = TRUE,
  fct.to.chr = FALSE,
  ...
)
}
\arguments{
\item{x}{a \code{freq()} or \code{descr()} output object.}

\item{order}{Integer. Useful for grouped results produced with
\code{\link{stby}} or \code{dplyr::group_by}. When set to \code{1}
 (default), the ordering is done using the grouping variables first.
 When set to \code{2}, the ordering is done according to the analytical 
 (not grouping) variable. When set to \code{3}, the same ordering
 as with \code{2} is used, but the analytical variable is placed in
 first position. Depending on what function was used for grouping,
 the results will be different in subtle ways. See \emph{Details}.}

\item{drop.var.col}{Logical. For \code{\link{descr}} objects, drop the
\code{variable} column. This is possible only when statistics are
produced for a single variable; when multiple variables are present,
this parameter is ignored. \code{FALSE} by default.}

\item{recalculate}{Logical. \strong{TRUE by default}. For grouped
\code{\link{freq}} results, recalculate percentages to have total
proportions sum up to 1. Defaults to \code{TRUE}.}

\item{fct.to.chr}{Logical. When grouped objects
are created with \code{dplyr::\link[dplyr]{group_by}}, the resulting
tibble will have factor columns when the grouping variable itself is
a factor. To convert them to character, set this to TRUE. See
\emph{Details}.}

\item{\dots}{For internal use only.}
}
\value{
A \code{\link[tibble]{tibble}} which is constructed following the
\emph{tidy} principles.
}
\description{
Make a tidy dataset out of freq() or descr() outputs
}
\details{
\code{stby}, which is based on and \code{by}, initially make the first
  variable vary, keeping the other(s) constant. On the other hand,
  \code{group_by} initially keeps the first grouping variable(s) constant,
  making the last one vary. This will impact the ordering of the rows (and
  as a result, the cumulative percent columns, if present).
  
  Also, keep in mind that while \code{group_by} shows \code{NA} groups by
  default, \code{useNA = TRUE} must be used to achieve the same
  results with \code{stby}.
}
\examples{

tb(freq(iris$Species))
tb(descr(iris, stats = "common"))

data("tobacco")
tb(stby(tobacco, tobacco$gender, descr, stats = "fivenum",check.nas = FALSE), 
   order=3)
tb(stby(tobacco, tobacco$gender, descr, stats = "common", useNA = TRUE))

# Compare stby() and group_by() groups' ordering
tb(with(tobacco, stby(diseased, list(gender, smoker), freq, useNA = TRUE)))
tobacco |> dplyr::group_by(gender, smoker) |> freq(diseased) |> tb()

}
