% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evaluation.R
\name{evaluate_survdnn}
\alias{evaluate_survdnn}
\title{Evaluate a survdnn Model Using Survival Metrics}
\usage{
evaluate_survdnn(
  model,
  metrics = c("cindex", "brier", "ibs"),
  times,
  newdata = NULL
)
}
\arguments{
\item{model}{A fitted `survdnn` model object.}

\item{metrics}{A character vector of metric names: `"cindex"`, `"brier"`, `"ibs"`.}

\item{times}{A numeric vector of evaluation time points.}

\item{newdata}{Optional. A data frame on which to evaluate the model. Defaults to training data.}
}
\value{
A tibble with evaluation results, containing at least `metric`, `value`, and possibly `time`.
}
\description{
Computes evaluation metrics for a fitted `survdnn` model at one or more time points.
Supported metrics include the concordance index (`"cindex"`), Brier score (`"brier"`),
and integrated Brier score (`"ibs"`).
}
\examples{
\donttest{
library(survival)
data(veteran)
\donttest{
mod <- survdnn(Surv(time, status) ~ age + karno + celltype,
               data = veteran, epochs = 5, verbose = FALSE)
evaluate_survdnn(mod, metrics = c("cindex", "ibs"), times = c(30, 90, 180))
evaluate_survdnn(mod, metrics = "brier", times = c(30, 90, 180))
}
}
}
