context("simulate_feature_data")

test_that("simulate_feature_data", {
  # data
  d <- simulate_feature_data(5, 0.5)
  # tests
  expect_is(d, "tbl_df")
  expect_equal(nrow(d), 5)
  expect_is(d$name, "character")
  expect_equal(anyDuplicated(d$name), 0)
  expect_is(d$survey, "logical")
  expect_equal(sum(d$survey), 3)
  expect_is(d$target, "numeric")
  expect_gt(min(d$target), 0)
  expect_true(all(is.finite(d$target)))
  expect_is(d$survey_sensitivity, "numeric")
  expect_gt(min(d$survey_sensitivity), 0)
  expect_lt(min(d$survey_sensitivity), 1)
  expect_true(all(is.finite(d$survey_sensitivity)))
  expect_is(d$survey_sensitivity, "numeric")
  expect_gt(min(d$survey_sensitivity), 0)
  expect_lt(min(d$survey_sensitivity), 1)
  expect_true(all(is.finite(d$survey_sensitivity)))
  expect_is(d$model_sensitivity, "numeric")
  expect_gt(min(d$model_sensitivity), 0)
  expect_lt(min(d$model_sensitivity), 1)
  expect_true(all(is.finite(d$model_sensitivity)))
  expect_is(d$model_specificity, "numeric")
  expect_gt(min(d$model_specificity), 0)
  expect_lt(min(d$model_specificity), 1)
  expect_true(all(is.finite(d$model_specificity)))
})
