% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hardhat.R
\name{check_compliant_node}
\alias{check_compliant_node}
\title{Check that Node object names are compliant}
\usage{
check_compliant_node(node)
}
\arguments{
\item{node}{the Node object, or a dataframe ready to be parsed by \code{data.tree::as.Node()}}
}
\value{
node if it is compliant, else an Error with the column names to fix
}
\description{
Check that Node object names are compliant
}
\examples{
\dontshow{if ((require("data.tree") || require("dplyr"))) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(dplyr)
library(data.tree)
data(starwars)
starwars_tree <- starwars \%>\%
  mutate(pathString = paste("tree", species, homeworld, `name`, sep = "/"))

# pre as.Node() check
try(check_compliant_node(starwars_tree))

# post as.Node() check
check_compliant_node(as.Node(starwars_tree))
\dontshow{\}) # examplesIf}
}
