% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cline.R
\name{cline}
\alias{cline}
\title{Add colored line segments to a plot}
\usage{
cline(x, y, z, color_vector)
}
\arguments{
\item{x}{x positions of points to be plotted}

\item{y}{y positions of points to be plotted}

\item{z}{a factor, the same length as x and y. Line segments in the resulting plot will be colored according to the levels of z.}

\item{color_vector}{a list of colors to use (length should match the number of levels in z).}
}
\value{
adds colored lines to a graph
}
\description{
This function adds colored line segments to an existing plot.  The line is plotted at points specified by inputs x and y, and colored according to factor input z (with one color for each level of z).
}
\examples{
cline(x=ChickWeight$Time, y=ChickWeight$weight, 
      z=as.factor(ChickWeight$Diet), 
      color_vector=c('black', 'grey20', 
                     'grey50', 'grey70'))
}
