% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/crop_to.R
\name{crop_to}
\alias{crop_to}
\title{Reduce the time span of data}
\usage{
crop_to(X, sampling_rate = NULL, tcues, times = NULL)
}
\arguments{
\item{X}{A sensor list, vector, or matrix. X can be regularly or irregularly samples data in any frame and unit.}

\item{sampling_rate}{The sampling rate of X in Hz. This is only needed if X is not a sensor structure.}

\item{tcues}{A two-element vector containing the start and end time cues in seconds of the data segment to keep (i.e., tcues <- c(start_time, end_time)).}

\item{times}{A vector of sampling times for X. This is only needed if X is not a sensor list and X is not regularly sampled.}
}
\value{
Cropped data in the same format as X, unless X is irregularly sampled and NOT a sensor list. In that case, the function returns a list with 2 elements:
\itemize{
 \item{\strong{X: }} A sensor list, vector or matrix containing the cropped data segment. If the input is a sensor list, the output will also be. The output has the same units, frame and sampling characteristics as the input.
 \item{\strong{times: }} A vector of sampling times for Y. This is only returned if X is irregularly sampled and X is not a sensor list. (If X is a sensor list, the sampling times are stored in the list.)
}
}
\description{
This function is used to reduce the time span of data by cropping out any data that falls before and after two time cues.
}
\examples{
         d <- find_dives(beaked_whale$P,300) 
         P2 <- crop_to(beaked_whale$P, tcues = c(d$start[1], d$end[1]))	#crop to 1st dive
         plott_base(X = list(P2), r=c(1), panel_labels=c('Depth'))
}
