% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tcplPlot.R
\name{tcplPlot}
\alias{tcplPlot}
\title{#-------------------------------------------------------------------------------
 Generic Plotting Function for tcpl}
\usage{
tcplPlot(
  lvl = 5,
  fld = "m4id",
  val = NULL,
  type = "mc",
  by = NULL,
  output = c("console", "pdf", "png", "jpg", "svg", "tiff"),
  fileprefix = paste0("tcplPlot_", Sys.Date()),
  multi = NULL,
  verbose = FALSE,
  nrow = NULL,
  ncol = NULL,
  dpi = 600
)
}
\arguments{
\item{lvl}{Integer of length 1, the level of data to load.}

\item{fld}{Character, the field(s) to query on.}

\item{val}{List, vectors of values for each field to query on. Must be in
the same order as 'fld'.}

\item{type}{Character of length 1, the data type, "sc" or "mc".}

\item{by}{Parameter to divide files into e.g. "aeid".}

\item{output}{How should the plot be presented. To view the plot in application,
use "console", or to save as a file type, use "pdf", "jpg", "png", "svg", or "tiff".}

\item{fileprefix}{Prefix of file when saving.}

\item{multi}{Boolean, by default TRUE for "pdf". If multi is TRUE, output
by  default 4 plots per page for 'verbose' = TRUE and 6 plots per page for
'verbose' = FALSE.}

\item{verbose}{Boolean, by default FALSE. If TRUE, a table with fitting parameters
is included with the plot.}

\item{nrow}{Integer, number of rows in multiplot. By default 2.}

\item{ncol}{Integer, number of columns in multiplot. By default 3, 2 if verbose.}

\item{dpi}{Integer, image print resolution. By default 600.}
}
\description{
\code{tcplLoadData} queries the tcpl databases and returns a plot
for the given level and data type.
}
\details{
The data type can be either 'mc' for mutliple concentration data, or 'sc'
for single concentration data. Multiple concentration data will be loaded
into the 'mc' tables, whereas the single concentration will be loaded into
the 'sc' tables.

Setting 'lvl' to "agg" will return an aggregate table containing the m4id
with the concentration-response data and m3id to map back to well-level
information.

Leaving \code{fld} NULL will return all data.
}
\examples{
## Store the current config settings, so they can be reloaded at the end
## of the examples
conf_store <- tcplConfList()
tcplConfExample()

tcplPlot(lvl = 4, fld = "m4id", val = c(18609966)) ## Create a level 4 plot

## Reset configuration
options(conf_store)
}
