% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FileBlock.R
\docType{class}
\name{FileBlock}
\alias{FileBlock}
\title{\code{FileBlock}}
\description{
\code{FileBlock} manages file-based content in a report,
ensuring appropriate handling of content files.
}
\examples{

## ------------------------------------------------
## Method `FileBlock$from_list`
## ------------------------------------------------

FileBlock <- getFromNamespace("FileBlock", "teal.reporter")
block <- FileBlock$new()
file_path <- tempfile(fileext = ".png")
saveRDS(iris, file_path)
block$from_list(list(basename = basename(file_path)), dirname(file_path))


## ------------------------------------------------
## Method `FileBlock$to_list`
## ------------------------------------------------

FileBlock <- getFromNamespace("FileBlock", "teal.reporter")
block <- FileBlock$new()
block$to_list(tempdir())

}
\keyword{internal}
\section{Super class}{
\code{\link[teal.reporter:ContentBlock]{teal.reporter::ContentBlock}} -> \code{FileBlock}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-FileBlock-finalize}{\code{FileBlock$finalize()}}
\item \href{#method-FileBlock-from_list}{\code{FileBlock$from_list()}}
\item \href{#method-FileBlock-to_list}{\code{FileBlock$to_list()}}
\item \href{#method-FileBlock-clone}{\code{FileBlock$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="ContentBlock" data-id="get_content"><a href='../../teal.reporter/html/ContentBlock.html#method-ContentBlock-get_content'><code>teal.reporter::ContentBlock$get_content()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="ContentBlock" data-id="initialize"><a href='../../teal.reporter/html/ContentBlock.html#method-ContentBlock-initialize'><code>teal.reporter::ContentBlock$initialize()</code></a></span></li>
<li><span class="pkg-link" data-pkg="teal.reporter" data-topic="ContentBlock" data-id="set_content"><a href='../../teal.reporter/html/ContentBlock.html#method-ContentBlock-set_content'><code>teal.reporter::ContentBlock$set_content()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileBlock-finalize"></a>}}
\if{latex}{\out{\hypertarget{method-FileBlock-finalize}{}}}
\subsection{Method \code{finalize()}}{
Finalize the \code{FileBlock}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileBlock$finalize()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Removes the temporary file created in the constructor.
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileBlock-from_list"></a>}}
\if{latex}{\out{\hypertarget{method-FileBlock-from_list}{}}}
\subsection{Method \code{from_list()}}{
Create the \code{FileBlock} from a list.
The list should contain one named field, \code{"basename"}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileBlock$from_list(x, output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{(\verb{named list}) with one field \code{"basename"}, a name of the file.}

\item{\code{output_dir}}{(\code{character}) with a path to the directory where a file will be copied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\code{self}, invisibly.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FileBlock <- getFromNamespace("FileBlock", "teal.reporter")
block <- FileBlock$new()
file_path <- tempfile(fileext = ".png")
saveRDS(iris, file_path)
block$from_list(list(basename = basename(file_path)), dirname(file_path))

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileBlock-to_list"></a>}}
\if{latex}{\out{\hypertarget{method-FileBlock-to_list}{}}}
\subsection{Method \code{to_list()}}{
Convert the \code{FileBlock} to a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileBlock$to_list(output_dir)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{(\code{character}) with a path to the directory where a file will be copied.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
\verb{named list} with a \code{basename} of the file.
}
\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{FileBlock <- getFromNamespace("FileBlock", "teal.reporter")
block <- FileBlock$new()
block$to_list(tempdir())

}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-FileBlock-clone"></a>}}
\if{latex}{\out{\hypertarget{method-FileBlock-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{FileBlock$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
