% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interpolation.R
\name{stress2grid}
\alias{stress2grid}
\title{Spatial interpolation of SHmax}
\source{
\url{https://github.com/MorZieg/Stress2Grid}
}
\usage{
stress2grid(
  x,
  stat = c("mean", "median"),
  grid = NULL,
  lon_range = NULL,
  lat_range = NULL,
  gridsize = 2,
  min_data = 3L,
  threshold = 25,
  arte_thres = 200,
  method_weighting = FALSE,
  quality_weighting = TRUE,
  dist_weight = c("inverse", "linear", "none"),
  idp = 1,
  qp = 1,
  mp = 1,
  dist_threshold = 0.1,
  R_range = seq(50, 1000, 50),
  ...
)
}
\arguments{
\item{x}{\code{sf} object containing
\describe{
\item{azi}{SHmax in degree}
\item{unc}{(optional) Uncertainties of SHmax in degree}
\item{type}{(optional) Methods used for the determination of the direction
of SHmax}
}}

\item{stat}{whether the direction of interpolated SHmax is based on the
circular mean and standard deviation (\code{"mean"}, the default) or the
circular median and interquartile range (\code{"median"})}

\item{grid}{(optional) Point object of class \code{sf}.}

\item{lon_range, lat_range}{(optional) numeric vector specifying the minimum
and maximum longitudes and latitudes (ignored if \code{grid} is specified).}

\item{gridsize}{numeric. Target spacing of the regular grid in decimal
degree. Default is \code{2.5}. (is ignored if \code{grid} is specified)}

\item{min_data}{integer. Minimum number of data per bin. Default is \code{3}}

\item{threshold}{numeric. Threshold for deviation of direction. Default is
25}

\item{arte_thres}{numeric. Maximum distance (in km) of the grid point to the
next data point. Default is \code{200}}

\item{method_weighting}{logical. If a method weighting should be applied:
Default is \code{FALSE}. If \code{FALSE}, overwrites \code{mp}.}

\item{quality_weighting}{logical. If a quality weighting should be applied:
Default is \code{TRUE}. If \code{FALSE}, overwrites \code{qp}.}

\item{dist_weight}{Distance weighting method which should be used. One of
\code{"none"}, \code{"linear"}, or \code{"inverse"} (the default).}

\item{idp, qp, mp}{numeric. The weighting power of inverse distance, quality
and method. Default is \code{1}. The higher the value, the more weight it will
put. When set to \code{0}, no weighting is applied. \code{idp} is only effective if
inverse distance weighting (\code{dist_weight="inverse"}) is applied.}

\item{dist_threshold}{numeric. Distance weight to prevent overweight of data
nearby (0 to 1). Default is \code{0.1}}

\item{R_range}{numeric value or vector specifying the kernel half-width(s),
i.e. the search radius (in km). Default is \code{seq(50, 1000, 50)}}

\item{...}{(optional) arguments to \code{\link[=dist_greatcircle]{dist_greatcircle()}}}
}
\value{
\code{sf} object containing
\describe{
\item{lon,lat}{longitude and latitude in degrees}
\item{azi}{Mean SHmax in degree}
\item{sd}{Standard deviation of SHmax in degrees}
\item{R}{Search radius in km}
\item{mdr}{Mean distance of datapoints per search radius}
\item{N}{Number of data points in search radius}
}
}
\description{
Stress field interpolation and wavelength analysis using a kernel (weighted)
mean/median and standard deviation/IQR of stress data
}
\details{
This is a modified version of the MATLAB script "stress2grid"
}
\examples{
data("san_andreas")
stress2grid(san_andreas, stat = "median")
}
\references{
Ziegler, M. and Heidbach, O. (2019).
Matlab Script Stress2Grid v1.1. GFZ Data Services. \doi{10.5880/wsm.2019.002}
}
\seealso{
\code{\link[=dist_greatcircle]{dist_greatcircle()}}, \code{\link[=PoR_stress2grid]{PoR_stress2grid()}}, \code{\link[=compact_grid]{compact_grid()}},
\code{\link[=circular_mean]{circular_mean()}}, \code{\link[=circular_median]{circular_median()}}, \code{\link[=circular_sd]{circular_sd()}}
}
